/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.util.List;
import org.opennms.core.tasks.BatchTask;
import org.opennms.core.tasks.RunInBatch;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SnmpAgentConfigFactory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.provision.NodePolicy;
import org.opennms.netmgt.provision.service.ProvisionService;
import org.opennms.netmgt.provision.service.ScanProgress;
import org.opennms.netmgt.provision.service.snmp.SystemGroup;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpWalker;
import org.springframework.util.Assert;

final class NodeInfoScan
implements RunInBatch {
    private final SnmpAgentConfigFactory m_agentConfigFactory;
    private final InetAddress m_agentAddress;
    private final String m_foreignSource;
    private OnmsNode m_node;
    private Integer m_nodeId;
    private boolean restoreCategories = false;
    private final ProvisionService m_provisionService;
    private final ScanProgress m_scanProgress;

    NodeInfoScan(OnmsNode node, InetAddress agentAddress, String foreignSource, ScanProgress scanProgress, SnmpAgentConfigFactory agentConfigFactory, ProvisionService provisionService, Integer nodeId) {
        this.m_node = node;
        this.m_agentAddress = agentAddress;
        this.m_foreignSource = foreignSource;
        this.m_scanProgress = scanProgress;
        this.m_agentConfigFactory = agentConfigFactory;
        this.m_provisionService = provisionService;
        this.m_nodeId = nodeId;
    }

    public void run(BatchTask phase) {
        phase.getBuilder().addSequence(new RunInBatch[]{new RunInBatch(){

            public void run(BatchTask batch) {
                NodeInfoScan.this.collectNodeInfo();
            }
        }, new RunInBatch(){

            public void run(BatchTask phase) {
                NodeInfoScan.this.doPersistNodeInfo();
            }
        }});
    }

    private InetAddress getAgentAddress() {
        return this.m_agentAddress;
    }

    private SnmpAgentConfig getAgentConfig(InetAddress primaryAddress) {
        return this.getAgentConfigFactory().getAgentConfig(primaryAddress);
    }

    private SnmpAgentConfigFactory getAgentConfigFactory() {
        return this.m_agentConfigFactory;
    }

    private String getForeignSource() {
        return this.m_foreignSource;
    }

    private ProvisionService getProvisionService() {
        return this.m_provisionService;
    }

    private void abort(String reason) {
        this.m_scanProgress.abort(reason);
    }

    private OnmsNode getNode() {
        return this.m_node;
    }

    private Integer getNodeId() {
        return this.m_nodeId;
    }

    private void setNode(OnmsNode node) {
        this.m_node = node;
    }

    private void collectNodeInfo() {
        Assert.notNull((Object)this.getAgentConfigFactory(), (String)"agentConfigFactory was not injected");
        InetAddress primaryAddress = this.getAgentAddress();
        SnmpAgentConfig agentConfig = this.getAgentConfig(primaryAddress);
        SystemGroup systemGroup = new SystemGroup(primaryAddress);
        SnmpWalker walker = SnmpUtils.createWalker((SnmpAgentConfig)agentConfig, (String)"systemGroup", (CollectionTracker)systemGroup);
        walker.start();
        try {
            walker.waitFor();
            if (walker.timedOut()) {
                this.abort("Aborting node scan : Agent timed out while scanning the system table");
            } else if (walker.failed()) {
                this.abort("Aborting node scan : Agent failed while scanning the system table: " + walker.getErrorMessage());
            } else {
                systemGroup.updateSnmpDataForNode(this.getNode());
            }
            List<NodePolicy> nodePolicies = this.getProvisionService().getNodePoliciesForForeignSource(this.getEffectiveForeignSource());
            OnmsNode node = null;
            if (this.isAborted()) {
                if (this.getNodeId() != null && nodePolicies.size() > 0) {
                    this.restoreCategories = true;
                    node = this.m_provisionService.getDbNodeInitCat(this.getNodeId());
                    LogUtils.debugf((Object)this, (String)"collectNodeInfo: checking %d node policies for restoration of categories", (Object[])new Object[]{nodePolicies.size()});
                }
            } else {
                node = this.getNode();
            }
            for (NodePolicy policy : nodePolicies) {
                if (node == null) continue;
                LogUtils.infof((Object)this, (String)"Applying NodePolicy %s(%s) to %s", (Object[])new Object[]{policy.getClass(), policy, node.getLabel()});
                node = policy.apply(node);
            }
            if (node == null) {
                this.restoreCategories = false;
                if (!this.isAborted()) {
                    String reason = "Aborted scan of node due to configured policy";
                    this.abort(reason);
                }
            } else {
                this.setNode(node);
            }
        }
        catch (InterruptedException e) {
            this.abort("Aborting node scan : Scan thread interrupted!");
            Thread.currentThread().interrupt();
        }
    }

    private String getEffectiveForeignSource() {
        return this.getForeignSource() == null ? "default" : this.getForeignSource();
    }

    private void doPersistNodeInfo() {
        if (this.restoreCategories) {
            LogUtils.debugf((Object)this, (String)"doPersistNodeInfo: Restoring %d categories to DB", (Object[])new Object[]{this.getNode().getCategories().size()});
        }
        if (!this.isAborted() || this.restoreCategories) {
            this.getProvisionService().updateNodeAttributes(this.getNode());
        }
    }

    private boolean isAborted() {
        return this.m_scanProgress.isAborted();
    }
}

