/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.command;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.provision.LocationAwareDetectorClient;
import org.opennms.netmgt.provision.detector.command.ServiceNameCompleter;

@Command(scope="opennms", name="detect", description="Detect the service on a host at specified location")
@Service
public class Detect
implements Action {
    @Option(name="-l", aliases={"--location"}, description="Location", required=false, multiValued=false)
    String m_location;
    @Option(name="-s", aliases={"--system-id"}, description="System ID")
    String m_systemId;
    @Argument(index=0, name="detectorType", description="Service to detect", required=true, multiValued=false)
    @Completion(value=ServiceNameCompleter.class)
    String serviceName;
    @Argument(index=1, name="host", description="Hostname or IP Address of the system to detect", required=true, multiValued=false)
    String m_host;
    @Argument(index=2, name="attributes", description="Detector attributes in key=value form", multiValued=true)
    List<String> attributes;
    @Reference
    public LocationAwareDetectorClient locationAwareDetectorClient;

    public Object execute() throws UnknownHostException {
        System.out.printf("Trying to detect '%s' on '%s' ", this.serviceName, this.m_host);
        CompletableFuture future = this.locationAwareDetectorClient.detect().withLocation(this.m_location).withSystemId(this.m_systemId).withServiceName(this.serviceName).withAddress(InetAddress.getByName(this.m_host)).withAttributes(Detect.parse(this.attributes)).execute();
        while (true) {
            try {
                try {
                    boolean isDetected = (Boolean)future.get(1L, TimeUnit.SECONDS);
                    System.out.printf("\n'%s' %s detected on %s\n", this.serviceName, isDetected ? "WAS" : "WAS NOT", this.m_host);
                }
                catch (InterruptedException e) {
                    System.out.println("\nInterrupted.");
                }
                catch (ExecutionException e) {
                    System.out.printf("\nDetection failed with: %s\n", e);
                }
            }
            catch (TimeoutException timeoutException) {
                System.out.print(".");
                System.out.flush();
                continue;
            }
            break;
        }
        return null;
    }

    private static Map<String, String> parse(List<String> attributeList) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (attributeList != null) {
            for (String keyValue : attributeList) {
                int splitAt = keyValue.indexOf("=");
                if (splitAt <= 0) {
                    throw new IllegalArgumentException("Invalid property " + keyValue);
                }
                String key = keyValue.substring(0, splitAt);
                String value = keyValue.substring(splitAt + 1, keyValue.length());
                properties.put(key, value);
            }
        }
        return properties;
    }
}

