/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.Client;

public class ClientConversation<Request, Response> {
    private ResponseValidator<Response> m_bannerValidator;
    private List<ClientExchange<Request, Response>> m_conversation = new ArrayList<ClientExchange<Request, Response>>();

    public void expectBanner(ResponseValidator<Response> bannerValidator) {
        this.m_bannerValidator = bannerValidator;
    }

    public void addExchange(final Request request, ResponseValidator<Response> validator) {
        RequestBuilder builder = new RequestBuilder<Request>(){

            @Override
            public Request getRequest() {
                return request;
            }
        };
        this.addExchange(builder, validator);
    }

    public void addExchange(RequestBuilder<Request> requestBuilder, ResponseValidator<Response> validator) {
        this.addExchange(new SimpleClientExchange<Request, Response>(requestBuilder, validator));
    }

    public void addExchange(ClientExchange<Request, Response> exchange) {
        this.m_conversation.add(exchange);
    }

    public boolean attemptConversation(Client<Request, Response> client) throws IOException, Exception {
        Response banner;
        if (this.m_bannerValidator != null && !this.m_bannerValidator.validate(banner = client.receiveBanner())) {
            LogUtils.infof((Object)this, (String)"False on Banner", (Object[])new Object[0]);
            return false;
        }
        for (ClientExchange<Request, Response> ex : this.m_conversation) {
            Object request = ex.getRequest();
            LogUtils.infof((Object)this, (String)"Sending Request %s\n", (Object[])new Object[]{request});
            Response response = client.sendRequest(request);
            LogUtils.infof((Object)this, (String)"Received Response %s\n", (Object[])new Object[]{response});
            if (ex.validate(response)) continue;
            return false;
        }
        return true;
    }

    public static class SimpleClientExchange<Request, RespType>
    implements ClientExchange<Request, RespType> {
        private RequestBuilder<Request> m_requestBuilder;
        private ResponseValidator<RespType> m_responseValidator;

        public SimpleClientExchange(RequestBuilder<Request> reqBuilder, ResponseValidator<RespType> respValidator) {
            this.m_requestBuilder = reqBuilder;
            this.m_responseValidator = respValidator;
        }

        @Override
        public Request getRequest() throws Exception {
            return this.m_requestBuilder.getRequest();
        }

        @Override
        public boolean validate(RespType response) throws Exception {
            return this.m_responseValidator.validate(response);
        }
    }

    public static interface ClientExchange<Request, Response>
    extends RequestBuilder<Request>,
    ResponseValidator<Response> {
    }

    public static interface ResponseValidator<T> {
        public boolean validate(T var1) throws Exception;
    }

    public static interface RequestBuilder<T> {
        public T getRequest() throws Exception;
    }
}

