/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.support.AbstractDetector;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ClientConversation;

public abstract class BasicDetector<Request, Response>
extends AbstractDetector
implements SyncServiceDetector {
    private ClientConversation<Request, Response> m_conversation = new ClientConversation();

    protected BasicDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    protected BasicDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    @Override
    protected abstract void onInit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isServiceDetected(InetAddress address, DetectorMonitor detectorMonitor) {
        String ipAddr = InetAddressUtils.str((InetAddress)address);
        int port = this.getPort();
        int retries = this.getRetries();
        int timeout = this.getTimeout();
        LogUtils.infof((Object)this, (String)"Address: %s || port: %s || \n", (Object[])new Object[]{address, this.getPort()});
        detectorMonitor.start(this, "Checking address: %s for %s capability", address, this.getServiceName());
        Client<Request, Response> client = this.getClient();
        for (int attempts = 0; attempts <= retries; ++attempts) {
            try {
                client.connect(address, port, timeout);
                detectorMonitor.attempt(this, attempts, "Attempting to connect to address: %s port %d attempt #%s", ipAddr, port, attempts);
                if (!this.attemptConversation(client)) continue;
                boolean bl = true;
                return bl;
            }
            catch (ConnectException cE) {
                detectorMonitor.info(this, cE, "%s: Excpetion attempting to connect to address: %s port %d, attempt #%s", this.getServiceName(), ipAddr, port, attempts);
                continue;
            }
            catch (NoRouteToHostException e) {
                detectorMonitor.info(this, e, "%s: No route to address %s was available", this.getServiceName(), ipAddr);
                throw new UndeclaredThrowableException(e);
            }
            catch (InterruptedIOException e) {
                detectorMonitor.info(this, e, "%s: Did not connect to to address %s port %d within timeout: %d attempt: %d", this.getServiceName(), ipAddr, port, timeout, attempts);
                continue;
            }
            catch (IOException e) {
                detectorMonitor.info(this, e, "%s: An unexpected I/O exception occured contacting address %s port %d", this.getServiceName(), ipAddr, port);
                continue;
            }
            catch (Throwable t) {
                detectorMonitor.failure(this, "%s: Failed to detect %s on address %s port %d", this.getServiceName(), this.getServiceName(), ipAddr, port);
                detectorMonitor.error(this, t, "%s: An undeclared throwable exception was caught contating address %s port %d", this.getServiceName(), ipAddr, port);
                continue;
            }
            finally {
                client.close();
            }
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    protected abstract Client<Request, Response> getClient();

    private boolean attemptConversation(Client<Request, Response> client) throws IOException, Exception {
        return this.getConversation().attemptConversation(client);
    }

    protected void expectBanner(ClientConversation.ResponseValidator<Response> bannerValidator) {
        this.getConversation().expectBanner(bannerValidator);
    }

    protected void send(ClientConversation.RequestBuilder<Request> requestBuilder, ClientConversation.ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(requestBuilder, responseValidator);
    }

    protected void send(Request request, ClientConversation.ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(request, responseValidator);
    }

    protected ClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }
}

