/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketConnector;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.support.AsyncAbstractDetector;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.BaseDetectorHandler;
import org.opennms.netmgt.provision.support.ConnectorFactory;
import org.opennms.netmgt.provision.support.DefaultDetectFuture;
import org.opennms.netmgt.provision.support.trustmanager.RelaxedX509TrustManager;

public abstract class AsyncBasicDetector<Request, Response>
extends AsyncAbstractDetector {
    protected static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");
    private BaseDetectorHandler<Request, Response> m_detectorHandler = new BaseDetectorHandler();
    private IoFilterAdapter m_filterLogging;
    private ProtocolCodecFilter m_protocolCodecFilter = new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(CHARSET_UTF8));
    private int m_idleTime = 1;
    private AsyncClientConversation<Request, Response> m_conversation = new AsyncClientConversation();
    private boolean useSSLFilter = false;
    private ConnectorFactory s_connectorFactory = new ConnectorFactory();
    private SocketConnector m_connector;

    public AsyncBasicDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncBasicDetector(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    @Override
    protected abstract void onInit();

    @Override
    public DetectFuture isServiceDetected(InetAddress address, DetectorMonitor monitor) throws Exception {
        this.m_connector = this.s_connectorFactory.getConnector();
        DefaultDetectFuture future = new DefaultDetectFuture(this);
        this.m_connector.setConnectTimeoutMillis((long)this.getTimeout());
        this.m_connector.setHandler(this.createDetectorHandler(future));
        if (this.isUseSSLFilter()) {
            SslFilter filter = new SslFilter(this.createClientSSLContext());
            filter.setUseClientMode(true);
            this.m_connector.getFilterChain().addFirst("SSL", (IoFilter)filter);
        }
        this.m_connector.getFilterChain().addLast("logger", (IoFilter)(this.getLoggingFilter() != null ? this.getLoggingFilter() : new LoggingFilter()));
        this.m_connector.getFilterChain().addLast("codec", (IoFilter)this.getProtocolCodecFilter());
        this.m_connector.getSessionConfig().setIdleTime(IdleStatus.READER_IDLE, this.getIdleTime());
        InetSocketAddress socketAddress = new InetSocketAddress(address, this.getPort());
        ConnectFuture cf = this.m_connector.connect((SocketAddress)socketAddress);
        cf.addListener(this.retryAttemptListener(this.m_connector, future, socketAddress, this.getRetries()));
        return future;
    }

    @Override
    public void dispose() {
        LogUtils.debugf((Object)this, (String)"calling dispose on detector %s", (Object[])new Object[]{this.getServiceName()});
        this.s_connectorFactory.dispose(this.m_connector);
        this.m_connector = null;
    }

    private SSLContext createClientSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509TrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        return sslContext;
    }

    private IoFutureListener<ConnectFuture> retryAttemptListener(final SocketConnector connector, final DetectFuture detectFuture, final InetSocketAddress address, final int retryAttempt) {
        return new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                Throwable cause = future.getException();
                if (cause instanceof ConnectException) {
                    if (retryAttempt == 0) {
                        LogUtils.infof((Object)this, (String)"service %s detected false", (Object[])new Object[]{AsyncBasicDetector.this.getServiceName()});
                        detectFuture.setServiceDetected(false);
                    } else {
                        LogUtils.infof((Object)this, (String)"Connection exception occurred %s for service %s retrying attempt: ", (Object[])new Object[]{cause, AsyncBasicDetector.this.getServiceName()});
                        future = connector.connect((SocketAddress)address);
                        future.addListener(AsyncBasicDetector.this.retryAttemptListener(connector, detectFuture, address, retryAttempt - 1));
                    }
                } else if (cause instanceof Throwable) {
                    LogUtils.infof((Object)this, (String)"Threw a Throwable and detection is false for service %s", (Object[])new Object[]{AsyncBasicDetector.this.getServiceName()});
                    detectFuture.setServiceDetected(false);
                }
            }
        };
    }

    protected void expectBanner(AsyncClientConversation.ResponseValidator<Response> bannerValidator) {
        this.getConversation().setHasBanner(true);
        this.getConversation().addExchange(new AsyncClientConversation.AsyncExchangeImpl<Object, Response>(null, bannerValidator));
    }

    protected void send(Request request, AsyncClientConversation.ResponseValidator<Response> responseValidator) {
        this.getConversation().addExchange(new AsyncClientConversation.AsyncExchangeImpl<Request, Response>(request, responseValidator));
    }

    protected void setDetectorHandler(BaseDetectorHandler<Request, Response> detectorHandler) {
        this.m_detectorHandler = detectorHandler;
    }

    protected IoHandler createDetectorHandler(DetectFuture future) {
        this.m_detectorHandler.setConversation(this.getConversation());
        this.m_detectorHandler.setFuture(future);
        return this.m_detectorHandler;
    }

    protected void setLoggingFilter(IoFilterAdapter filterLogging) {
        this.m_filterLogging = filterLogging;
    }

    protected IoFilterAdapter getLoggingFilter() {
        return this.m_filterLogging;
    }

    protected void setProtocolCodecFilter(ProtocolCodecFilter protocolCodecFilter) {
        this.m_protocolCodecFilter = protocolCodecFilter;
    }

    protected ProtocolCodecFilter getProtocolCodecFilter() {
        return this.m_protocolCodecFilter;
    }

    public void setIdleTime(int idleTime) {
        this.m_idleTime = idleTime;
    }

    public int getIdleTime() {
        return this.m_idleTime;
    }

    protected IoHandler getDetectorHandler() {
        return this.m_detectorHandler;
    }

    protected void setConversation(AsyncClientConversation<Request, Response> conversation) {
        this.m_conversation = conversation;
    }

    protected AsyncClientConversation<Request, Response> getConversation() {
        return this.m_conversation;
    }

    protected Request request(Request request) {
        return request;
    }

    protected AsyncClientConversation.ResponseValidator<Response> startsWith(final String prefix) {
        return new AsyncClientConversation.ResponseValidator<Response>(){

            @Override
            public boolean validate(Object message) {
                String str = message.toString().trim();
                return str.startsWith(prefix);
            }
        };
    }

    public AsyncClientConversation.ResponseValidator<Response> find(final String regex) {
        return new AsyncClientConversation.ResponseValidator<Response>(){

            @Override
            public boolean validate(Object message) {
                String str = message.toString().trim();
                return Pattern.compile(regex).matcher(str).find();
            }
        };
    }

    public void setUseSSLFilter(boolean useSSLFilter) {
        this.useSSLFilter = useSSLFilter;
    }

    public boolean isUseSSLFilter() {
        return this.useSSLFilter;
    }
}

