/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.InetAddress;
import org.opennms.netmgt.provision.AsyncServiceDetector;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.DetectorMonitor;

public abstract class AsyncAbstractDetector
implements AsyncServiceDetector {
    private static final int DEFAULT_RETRIES = 1;
    private static final int DEFAULT_TIMEOUT = 2000;
    private int m_port;
    private int m_retries;
    private int m_timeout;
    private String m_serviceName;

    protected AsyncAbstractDetector(String serviceName, int port) {
        this(serviceName, port, 2000, 1);
    }

    protected AsyncAbstractDetector(String serviceName, int port, int timeout, int retries) {
        this.m_serviceName = serviceName;
        this.m_port = port;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    @Override
    public void init() {
        if (this.m_serviceName == null || this.m_timeout <= 0) {
            throw new IllegalStateException(String.format("ServiceName is null or timeout of %d is invalid.  Timeout must be > 0", this.m_timeout));
        }
        this.onInit();
    }

    protected abstract void onInit();

    @Override
    public abstract DetectFuture isServiceDetected(InetAddress var1, DetectorMonitor var2) throws Exception;

    @Override
    public abstract void dispose();

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }
}

