/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.InetAddress;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.DetectorMonitor;
import org.opennms.netmgt.provision.SyncServiceDetector;

public abstract class AbstractDetector
implements SyncServiceDetector {
    private static final int DEFAULT_TIMEOUT = 2000;
    private static final int DEFAULT_RETRIES = 1;
    private int m_port;
    private int m_retries;
    private int m_timeout;
    private String m_serviceName;

    @Deprecated
    protected AbstractDetector() {
    }

    protected AbstractDetector(String serviceName, int port, int timeout, int retries) {
        this.m_serviceName = serviceName;
        this.m_port = port;
        this.m_timeout = timeout;
        this.m_retries = retries;
    }

    public AbstractDetector(String serviceName, int port) {
        this(serviceName, port, 2000, 1);
        this.m_port = port;
    }

    @Override
    public void init() {
        if (this.m_serviceName == null || this.m_timeout <= 0) {
            throw new IllegalStateException(String.format("ServiceName and/or timeout of %d is invalid.  ServiceName can't be null and timeout must be > 0", this.m_timeout));
        }
        this.onInit();
    }

    protected abstract void onInit();

    @Override
    public abstract boolean isServiceDetected(InetAddress var1, DetectorMonitor var2);

    @Override
    public abstract void dispose();

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setRetries(int retries) {
        this.m_retries = retries;
    }

    public int getRetries() {
        return this.m_retries;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    protected ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }
}

