/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncClientConversation<Request, Response> {
    private final List<AsyncExchange<Request, Response>> m_conversation = new ArrayList<AsyncExchange<Request, Response>>();
    private boolean m_isComplete = false;
    private boolean m_hasBanner = false;

    public void addExchange(AsyncExchange<Request, Response> request) {
        this.m_conversation.add(request);
    }

    public void setHasBanner(boolean hasBanner) {
        this.m_hasBanner = hasBanner;
    }

    public boolean hasBanner() {
        return this.m_hasBanner;
    }

    public boolean hasExchanges() {
        return !this.m_conversation.isEmpty();
    }

    public boolean isComplete() {
        return this.m_isComplete;
    }

    public boolean validate(Response message) {
        AsyncExchange<Request, Response> ex = this.m_conversation.remove(0);
        if (this.m_conversation.isEmpty()) {
            this.m_isComplete = true;
        }
        return ex.validateResponse(message);
    }

    public Request getRequest() {
        return this.extracted();
    }

    private Request extracted() {
        return this.m_conversation.isEmpty() ? null : (Request)this.m_conversation.get(0).getRequest();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AsyncExchangeImpl<Request, Response>
    implements AsyncExchange<Request, Response> {
        private final Request m_request;
        private final ResponseValidator<Response> m_responseValidator;

        public AsyncExchangeImpl(Request request, ResponseValidator<Response> responseValidator) {
            this.m_request = request;
            this.m_responseValidator = responseValidator;
        }

        @Override
        public Request getRequest() {
            return this.m_request;
        }

        @Override
        public boolean validateResponse(Response message) {
            return this.m_responseValidator.validate(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AsyncExchange<Request, Response> {
        public boolean validateResponse(Response var1);

        public Request getRequest();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResponseValidator<Response> {
        public boolean validate(Response var1);
    }
}

