/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.PausibleScheduledThreadPoolExecutor;
import org.opennms.netmgt.provision.ProvisioningAdapter;
import org.opennms.netmgt.provision.ProvisioningAdapterException;

public abstract class SimpleQueuedProvisioningAdapter2
implements ProvisioningAdapter {
    private volatile PausibleScheduledThreadPoolExecutor m_executorService;

    protected SimpleQueuedProvisioningAdapter2(PausibleScheduledThreadPoolExecutor executorService) {
        this.m_executorService = executorService;
    }

    protected SimpleQueuedProvisioningAdapter2() {
        this(SimpleQueuedProvisioningAdapter2.createDefaultSchedulerService());
    }

    private static PausibleScheduledThreadPoolExecutor createDefaultSchedulerService() {
        PausibleScheduledThreadPoolExecutor executorService = new PausibleScheduledThreadPoolExecutor(1);
        return executorService;
    }

    public abstract String getName();

    public abstract boolean isNodeReady(int var1);

    public abstract void processPendingOperationForNode(AdapterOperation var1) throws ProvisioningAdapterException;

    AdapterOperationSchedule createScheduleForNode(int nodeId, AdapterOperationType adapterOperationType) {
        return new AdapterOperationSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addNode(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.ADD, this.createScheduleForNode(nodeId, AdapterOperationType.ADD));
        PausibleScheduledThreadPoolExecutor pausibleScheduledThreadPoolExecutor = this.m_executorService;
        synchronized (pausibleScheduledThreadPoolExecutor) {
            if (!this.m_executorService.getQueue().contains(op)) {
                op.schedule((ScheduledExecutorService)this.m_executorService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateNode(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.UPDATE, this.createScheduleForNode(nodeId, AdapterOperationType.UPDATE));
        PausibleScheduledThreadPoolExecutor pausibleScheduledThreadPoolExecutor = this.m_executorService;
        synchronized (pausibleScheduledThreadPoolExecutor) {
            if (!this.m_executorService.getQueue().contains(op)) {
                op.schedule((ScheduledExecutorService)this.m_executorService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteNode(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.DELETE, this.createScheduleForNode(nodeId, AdapterOperationType.DELETE));
        PausibleScheduledThreadPoolExecutor pausibleScheduledThreadPoolExecutor = this.m_executorService;
        synchronized (pausibleScheduledThreadPoolExecutor) {
            if (!this.m_executorService.getQueue().contains(op)) {
                op.schedule((ScheduledExecutorService)this.m_executorService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void nodeConfigChanged(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.CONFIG_CHANGE, this.createScheduleForNode(nodeId, AdapterOperationType.CONFIG_CHANGE));
        PausibleScheduledThreadPoolExecutor pausibleScheduledThreadPoolExecutor = this.m_executorService;
        synchronized (pausibleScheduledThreadPoolExecutor) {
            if (!this.m_executorService.getQueue().contains(op)) {
                op.schedule((ScheduledExecutorService)this.m_executorService);
            }
        }
    }

    public PausibleScheduledThreadPoolExecutor getExecutorService() {
        return this.m_executorService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AdapterOperationType {
        ADD(1, "Add"),
        UPDATE(2, "Update"),
        DELETE(3, "Delete"),
        CONFIG_CHANGE(4, "Configuration Change");

        private static final Map<Integer, AdapterOperationType> m_idMap;
        private static final List<Integer> m_ids;
        private int m_id;
        private String m_label;

        private AdapterOperationType(int id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        private Integer getId() {
            return this.m_id;
        }

        public String toString() {
            return this.m_label;
        }

        public static AdapterOperationType get(int id) {
            if (m_idMap.containsKey(id)) {
                return m_idMap.get(id);
            }
            throw new IllegalArgumentException("Cannot create AdapterOperation from unknown ID " + id);
        }

        static {
            m_ids = new ArrayList<Integer>(AdapterOperationType.values().length);
            m_idMap = new HashMap<Integer, AdapterOperationType>(AdapterOperationType.values().length);
            for (AdapterOperationType operation : AdapterOperationType.values()) {
                m_ids.add(operation.getId());
                m_idMap.put(operation.getId(), operation);
            }
        }
    }

    static class AdapterOperationSchedule {
        long m_initalDelay;
        long m_interval;
        TimeUnit m_unit;

        public AdapterOperationSchedule(long initalDelay, long interval, TimeUnit unit) {
            this.m_initalDelay = initalDelay;
            this.m_interval = interval;
            this.m_unit = unit;
        }

        public AdapterOperationSchedule() {
            this(60L, 60L, TimeUnit.SECONDS);
        }

        public long getInitalDelay() {
            return this.m_initalDelay;
        }

        public long getInterval() {
            return this.m_interval;
        }

        public TimeUnit getUnit() {
            return this.m_unit;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AdapterOperation
    implements Runnable {
        private final Integer m_nodeId;
        private final AdapterOperationType m_type;
        private AdapterOperationSchedule m_schedule;
        private final Date m_createTime;

        public AdapterOperation(Integer nodeId, AdapterOperationType type, AdapterOperationSchedule schedule) {
            this.m_nodeId = nodeId;
            this.m_type = type;
            this.m_schedule = schedule;
            this.m_createTime = new Date();
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public Date getCreateTime() {
            return this.m_createTime;
        }

        public AdapterOperationType getType() {
            return this.m_type;
        }

        public AdapterOperationSchedule getSchedule() {
            return this.m_schedule;
        }

        ScheduledFuture<?> schedule(ScheduledExecutorService executor) {
            ScheduledFuture<?> future = executor.scheduleWithFixedDelay(this, this.m_schedule.m_initalDelay, this.m_schedule.m_interval, this.m_schedule.m_unit);
            return future;
        }

        public boolean equals(Object that) {
            boolean equals = false;
            if (this == that) {
                equals = true;
            }
            if (that == null) {
                throw new IllegalArgumentException("the Operation Object passed is either null or of the wrong class");
            }
            if (this.m_nodeId == ((AdapterOperation)that).getNodeId() && this.m_type == ((AdapterOperation)that).getType()) {
                equals = true;
            }
            return equals;
        }

        public String toString() {
            return "Operation: " + (Object)((Object)this.m_type) + " on Node: " + this.m_nodeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SimpleQueuedProvisioningAdapter2.this.isNodeReady(this.m_nodeId)) {
                SimpleQueuedProvisioningAdapter2.this.processPendingOperationForNode(this);
            }
            if (SimpleQueuedProvisioningAdapter2.this.isNodeReady(this.m_nodeId)) {
                PausibleScheduledThreadPoolExecutor pausibleScheduledThreadPoolExecutor = SimpleQueuedProvisioningAdapter2.this.m_executorService;
                synchronized (pausibleScheduledThreadPoolExecutor) {
                    SimpleQueuedProvisioningAdapter2.this.processPendingOperationForNode(this);
                }
            }
        }
    }
}

