/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.PausibleScheduledThreadPoolExecutor;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.provision.ProvisioningAdapter;
import org.opennms.netmgt.provision.ProvisioningAdapterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleQueuedProvisioningAdapter
implements ProvisioningAdapter {
    private final AdapterOperationQueue m_operationQueue = new AdapterOperationQueue();
    private volatile PausibleScheduledThreadPoolExecutor m_executorService;

    protected SimpleQueuedProvisioningAdapter(PausibleScheduledThreadPoolExecutor executorService) {
        this.m_executorService = executorService;
    }

    protected SimpleQueuedProvisioningAdapter() {
        this(SimpleQueuedProvisioningAdapter.createDefaultSchedulerService());
    }

    private static final PausibleScheduledThreadPoolExecutor createDefaultSchedulerService() {
        PausibleScheduledThreadPoolExecutor executorService = new PausibleScheduledThreadPoolExecutor(1);
        return executorService;
    }

    @Override
    public abstract String getName();

    public abstract boolean isNodeReady(AdapterOperation var1);

    protected abstract void processPendingOperationForNode(AdapterOperation var1) throws ProvisioningAdapterException;

    AdapterOperationSchedule createScheduleForNode(int nodeId, AdapterOperationType adapterOperationType) {
        return new AdapterOperationSchedule(adapterOperationType);
    }

    final List<AdapterOperation> removeOperationsForNode(Integer nodeId) {
        return this.m_operationQueue.dequeueOperationsForNode(nodeId);
    }

    @Override
    public final void addNode(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.ADD, this.createScheduleForNode(nodeId, AdapterOperationType.ADD));
        if (this.m_operationQueue.enqueOperation(nodeId, op)) {
            op.schedule((ScheduledExecutorService)this.m_executorService, true);
        }
    }

    @Override
    public final void updateNode(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.UPDATE, this.createScheduleForNode(nodeId, AdapterOperationType.UPDATE));
        if (this.m_operationQueue.enqueOperation(nodeId, op)) {
            op.schedule((ScheduledExecutorService)this.m_executorService, true);
        }
    }

    @Override
    public final void deleteNode(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.DELETE, this.createScheduleForNode(nodeId, AdapterOperationType.DELETE));
        if (this.m_operationQueue.enqueOperation(nodeId, op)) {
            op.schedule((ScheduledExecutorService)this.m_executorService, true);
        }
    }

    @Override
    public final void nodeConfigChanged(int nodeId) {
        AdapterOperation op = new AdapterOperation(nodeId, AdapterOperationType.CONFIG_CHANGE, this.createScheduleForNode(nodeId, AdapterOperationType.CONFIG_CHANGE));
        if (this.m_operationQueue.enqueOperation(nodeId, op)) {
            op.schedule((ScheduledExecutorService)this.m_executorService, true);
        }
    }

    @Override
    public void init() {
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(SimpleQueuedProvisioningAdapter.class);
    }

    PausibleScheduledThreadPoolExecutor getExecutorService() {
        return this.m_executorService;
    }

    public AdapterOperationQueue getOperationQueue() {
        return this.m_operationQueue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AdapterOperationType {
        ADD(1, "Add"),
        UPDATE(2, "Update"),
        DELETE(3, "Delete"),
        CONFIG_CHANGE(4, "Configuration Change");

        private static final Map<Integer, AdapterOperationType> m_idMap;
        private static final List<Integer> m_ids;
        private int m_id;
        private String m_label;

        private AdapterOperationType(int id, String label) {
            this.m_id = id;
            this.m_label = label;
        }

        private Integer getId() {
            return this.m_id;
        }

        public String toString() {
            return this.m_label;
        }

        public static AdapterOperationType get(int id) {
            if (m_idMap.containsKey(id)) {
                return m_idMap.get(id);
            }
            throw new IllegalArgumentException("Cannot create AdapterOperation from unknown ID " + id);
        }

        static {
            m_ids = new ArrayList<Integer>(AdapterOperationType.values().length);
            m_idMap = new HashMap<Integer, AdapterOperationType>(AdapterOperationType.values().length);
            for (AdapterOperationType operation : AdapterOperationType.values()) {
                m_ids.add(operation.getId());
                m_idMap.put(operation.getId(), operation);
            }
        }
    }

    static class AdapterOperationSchedule {
        private static final int DEFAULT_ATTEMPTS = 1;
        private static final int DEFAULT_INTERVAL = 60;
        private static final int DEFAULT_INITIAL_DELAY = 300;
        long m_initialDelay;
        long m_interval;
        int m_attemptsRemaining;
        TimeUnit m_unit;

        public AdapterOperationSchedule(long initialDelay, long interval, int attempts, TimeUnit unit) {
            if (attempts < 1) {
                attempts = 1;
            }
            this.m_initialDelay = initialDelay;
            this.m_interval = interval;
            this.m_attemptsRemaining = attempts;
            this.m_unit = unit;
        }

        public AdapterOperationSchedule() {
            this(300L, 60L, 1, TimeUnit.SECONDS);
        }

        public AdapterOperationSchedule(AdapterOperationType type) {
            this(300L, 60L, 1, TimeUnit.SECONDS);
            if (type == AdapterOperationType.CONFIG_CHANGE) {
                this.m_initialDelay = 3600L;
                this.m_interval = 600L;
            }
        }

        public long getInitialDelay() {
            return this.m_initialDelay;
        }

        public long getInterval() {
            return this.m_interval;
        }

        public TimeUnit getUnit() {
            return this.m_unit;
        }

        public int getAttemptsRemaining() {
            return this.m_attemptsRemaining;
        }

        public int getAttemptsRemainingAndDecrement() {
            int currentAttemptsRemaining = this.m_attemptsRemaining--;
            return currentAttemptsRemaining;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AdapterOperationSchedule; Initial delay: ");
            sb.append(this.m_initialDelay);
            sb.append(", Interval: ");
            sb.append(this.m_interval);
            sb.append(", Attempts: ");
            sb.append(this.m_attemptsRemaining);
            sb.append(", Units: ");
            sb.append((Object)this.m_unit);
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AdapterOperation
    implements Runnable {
        private final Integer m_nodeId;
        private final AdapterOperationType m_type;
        private AdapterOperationSchedule m_schedule;
        private final Date m_createTime;

        public AdapterOperation(Integer nodeId, AdapterOperationType type, AdapterOperationSchedule schedule) {
            this.m_nodeId = nodeId;
            this.m_type = type;
            this.m_schedule = schedule;
            this.m_createTime = new Date();
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public Date getCreateTime() {
            return this.m_createTime;
        }

        public AdapterOperationType getType() {
            return this.m_type;
        }

        public AdapterOperationSchedule getSchedule() {
            return this.m_schedule;
        }

        ScheduledFuture<?> schedule(ScheduledExecutorService executor, boolean reduceAttempts) {
            ScheduledFuture<?> future = null;
            if (reduceAttempts) {
                if (this.getSchedule().getAttemptsRemainingAndDecrement() > 0) {
                    future = executor.schedule(this, this.m_schedule.getInitialDelay(), this.m_schedule.getUnit());
                }
            } else {
                future = executor.schedule(this, this.m_schedule.getInitialDelay(), this.m_schedule.getUnit());
            }
            return future;
        }

        public boolean equals(Object operation) {
            boolean equals = false;
            if (this == operation) {
                equals = true;
            }
            if (operation == null || operation.getClass() != this.getClass()) {
                throw new IllegalArgumentException("the Operation Object passed is either null or of the wrong class");
            }
            if (this.m_nodeId == ((AdapterOperation)operation).getNodeId() && this.m_type == ((AdapterOperation)operation).getType()) {
                equals = true;
            }
            return equals;
        }

        public String toString() {
            return "Operation: " + (Object)((Object)this.m_type) + " on Node: " + this.m_nodeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                try {
                    if (SimpleQueuedProvisioningAdapter.this.isNodeReady(this)) {
                        SimpleQueuedProvisioningAdapter.this.m_operationQueue.dequeueOperationForNode(this.m_nodeId, this);
                        AdapterOperation adapterOperation = this;
                        synchronized (adapterOperation) {
                            try {
                                SimpleQueuedProvisioningAdapter.this.processPendingOperationForNode(this);
                            }
                            catch (ProvisioningAdapterException e) {
                                SimpleQueuedProvisioningAdapter.log().warn("Exception thrown during adapter queuing, rescheduling: " + e.getMessage(), (Throwable)e);
                                this.schedule((ScheduledExecutorService)SimpleQueuedProvisioningAdapter.this.getExecutorService(), true);
                            }
                            finally {
                                this.notifyAll();
                            }
                            break block12;
                        }
                    }
                    this.schedule((ScheduledExecutorService)SimpleQueuedProvisioningAdapter.this.getExecutorService(), false);
                }
                catch (Throwable e) {
                    SimpleQueuedProvisioningAdapter.log().error("Unexpected exception during node operation: " + e.getMessage(), e);
                }
            }
        }
    }

    public static interface AdapterOperationQueueListener {
        public void onEnqueueOperation(AdapterOperation var1);

        public void onDequeueOperation(AdapterOperation var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdapterOperationQueue {
        private final List<AdapterOperationQueueListener> m_listeners = new ArrayList<AdapterOperationQueueListener>();
        private final ConcurrentHashMap<Integer, LinkedBlockingQueue<AdapterOperation>> m_mappedQueue = new ConcurrentHashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean enqueOperation(Integer nodeId, AdapterOperation op) {
            if (this.m_mappedQueue.containsKey(nodeId) && this.m_mappedQueue.get(nodeId).contains(op)) {
                return false;
            }
            if (this.m_mappedQueue.containsKey(nodeId) && !this.m_mappedQueue.get(nodeId).contains(op)) {
                this.m_mappedQueue.get(nodeId).offer(op);
            } else {
                LinkedBlockingQueue<AdapterOperation> queue = new LinkedBlockingQueue<AdapterOperation>();
                queue.offer(op);
                this.m_mappedQueue.put(nodeId, queue);
            }
            List<AdapterOperationQueueListener> list = this.m_listeners;
            synchronized (list) {
                for (AdapterOperationQueueListener listener : this.m_listeners) {
                    listener.onEnqueueOperation(op);
                }
            }
            return true;
        }

        public synchronized void enqueOperations(Integer nodeId, Collection<AdapterOperation> ops) {
            for (AdapterOperation op : ops) {
                this.enqueOperation(nodeId, op);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List<AdapterOperation> dequeueOperationsForNode(Integer nodeId) {
            ArrayList<AdapterOperation> ops = new ArrayList<AdapterOperation>();
            this.m_mappedQueue.get(nodeId).drainTo(ops);
            List<AdapterOperationQueueListener> list = this.m_listeners;
            synchronized (list) {
                for (AdapterOperation op : ops) {
                    for (AdapterOperationQueueListener listener : this.m_listeners) {
                        listener.onDequeueOperation(op);
                    }
                }
            }
            return ops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean dequeueOperationForNode(Integer nodeId, AdapterOperation op) {
            boolean retval = this.m_mappedQueue.get(nodeId).remove(op);
            List<AdapterOperationQueueListener> list = this.m_listeners;
            synchronized (list) {
                for (AdapterOperationQueueListener listener : this.m_listeners) {
                    listener.onDequeueOperation(op);
                }
            }
            return retval;
        }

        public synchronized LinkedBlockingQueue<AdapterOperation> getOperationQueueForNode(Integer nodeId) {
            return this.m_mappedQueue.get(nodeId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(AdapterOperationQueueListener listener) {
            List<AdapterOperationQueueListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(AdapterOperationQueueListener listener) {
            List<AdapterOperationQueueListener> list = this.m_listeners;
            synchronized (list) {
                this.m_listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<AdapterOperationQueueListener> getListeners() {
            List<AdapterOperationQueueListener> list = this.m_listeners;
            synchronized (list) {
                ArrayList<AdapterOperationQueueListener> retval = new ArrayList<AdapterOperationQueueListener>();
                for (AdapterOperationQueueListener listener : this.m_listeners) {
                    retval.add(listener);
                }
                return retval;
            }
        }
    }
}

