/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.SessionDelegateIoHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactory {
    private static Map<Integer, ConnectionFactory> s_connectorPool = new HashMap<Integer, ConnectionFactory>();
    private static Semaphore s_availableConnectors;
    private static Semaphore s_availableConnections;
    private int m_references;
    private NioSocketConnector m_connector = new NioSocketConnector();

    private ConnectionFactory(int timeoutInMillis) {
        this.m_connector.setHandler((IoHandler)new SessionDelegateIoHandler());
        this.m_connector.setConnectTimeoutMillis((long)timeoutInMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionFactory getFactory(int timeoutInMillis) {
        LogUtils.debugf(ConnectionFactory.class, (String)"Creating a ConnectionFactory for timeout %d, there are already %d factories", (Object[])new Object[]{timeoutInMillis, s_connectorPool.size()});
        if (s_availableConnectors != null) {
            s_availableConnectors.acquireUninterruptibly();
        }
        Map<Integer, ConnectionFactory> map = s_connectorPool;
        synchronized (map) {
            ConnectionFactory w = s_connectorPool.get(timeoutInMillis);
            if (w == null) {
                w = new ConnectionFactory(timeoutInMillis);
                s_connectorPool.put(timeoutInMillis, w);
            }
            ++w.m_references;
            return w;
        }
    }

    public ConnectFuture connect(SocketAddress destination, IoSessionInitializer<? extends ConnectFuture> init) {
        if (s_availableConnections != null) {
            s_availableConnections.acquireUninterruptibly();
        }
        return this.m_connector.connect(destination, init);
    }

    public ConnectFuture reConnect(SocketAddress destination, IoSessionInitializer<? extends ConnectFuture> init) {
        return this.m_connector.connect(destination, init);
    }

    public static void dispose(ConnectionFactory factory, ConnectFuture connection) {
        if (s_availableConnections != null) {
            s_availableConnections.release();
        }
        if (--factory.m_references <= 0) {
            if (s_availableConnectors != null) {
                s_availableConnectors.release();
            }
            Iterator<Map.Entry<Integer, ConnectionFactory>> i = s_connectorPool.entrySet().iterator();
            while (i.hasNext()) {
                if (i.next().getValue() != factory) continue;
                i.remove();
            }
            factory.m_connector.dispose();
        }
    }

    static {
        if (System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnectors") != null) {
            s_availableConnectors = Integer.parseInt(System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnectors")) == 0 ? null : new Semaphore(Integer.parseInt(System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnectors", "20")));
        }
        if (System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnections") != null) {
            s_availableConnectors = Integer.parseInt(System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnections")) == 0 ? null : new Semaphore(Integer.parseInt(System.getProperty("org.opennms.netmgt.provision.maxConcurrentConnections", "2000")));
        }
    }
}

