/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.mina.core.RuntimeIoException;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.core.session.IoSessionInitializer;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.provision.support.ConnectionFactory;

public class ConnectionFactoryNewConnectorImpl
extends ConnectionFactory {
    private static final Executor m_executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static final IoProcessor<NioSession> m_processor = new SimpleIoProcessorPool(NioProcessor.class, m_executor);
    private ThreadLocal<Integer> m_port = new ThreadLocal();
    private final Object m_portMutex = new Object();

    protected ConnectionFactoryNewConnectorImpl(int timeoutInMillis) {
        super(timeoutInMillis);
    }

    private static final NioSocketConnector getSocketConnector(long timeout, IoHandler handler) {
        NioSocketConnector connector = new NioSocketConnector(m_executor, m_processor);
        connector.getSessionConfig().setReuseAddress(true);
        connector.setHandler(handler);
        connector.setConnectTimeoutMillis(timeout);
        return connector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectFuture connect(SocketAddress remoteAddress, IoSessionInitializer<? extends ConnectFuture> init, IoHandler handler) {
        NioSocketConnector connector = ConnectionFactoryNewConnectorImpl.getSocketConnector(this.getTimeout(), handler);
        InetSocketAddress localAddress = null;
        Object object = this.m_portMutex;
        synchronized (object) {
            if (this.m_port.get() == null) {
                localAddress = new InetSocketAddress(0);
                this.m_port.set(localAddress.getPort());
            } else {
                localAddress = new InetSocketAddress(this.m_port.get());
            }
        }
        ConnectFuture cf = connector.connect(remoteAddress, (SocketAddress)localAddress, init);
        cf.addListener(this.portSwitcher((SocketConnector)connector, remoteAddress, init, handler));
        cf.addListener(ConnectionFactoryNewConnectorImpl.connectorDisposer((SocketConnector)connector));
        return cf;
    }

    private static IoFutureListener<ConnectFuture> connectorDisposer(final SocketConnector connector) {
        return new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture future) {
                try {
                    future.getSession().getCloseFuture().addListener((IoFutureListener)new IoFutureListener<CloseFuture>(){

                        public void operationComplete(CloseFuture future) {
                            LogUtils.debugf((Object)this, (String)"Disposing of connector: %s", (Object[])new Object[]{Thread.currentThread().getName()});
                            connector.dispose();
                        }
                    });
                }
                catch (RuntimeIoException e) {
                    LogUtils.debugf((Object)this, (Throwable)e, (String)"Exception of type %s caught, disposing of connector: %s", (Object[])new Object[]{((Object)((Object)e)).getClass().getName(), Thread.currentThread().getName()});
                    connector.dispose();
                }
            }
        };
    }

    private IoFutureListener<ConnectFuture> portSwitcher(final SocketConnector connector, final SocketAddress remoteAddress, final IoSessionInitializer<? extends ConnectFuture> init, final IoHandler handler) {
        return new IoFutureListener<ConnectFuture>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ConnectFuture future) {
                block5: {
                    try {
                        Throwable e = future.getException();
                        if (e == null || !(e instanceof BindException)) break block5;
                        Object object = ConnectionFactoryNewConnectorImpl.this.m_portMutex;
                        synchronized (object) {
                            LogUtils.warnf((Object)this, (String)"Resetting outgoing TCP port, value was %d", (Object[])new Object[]{ConnectionFactoryNewConnectorImpl.this.m_port.get()});
                            ConnectionFactoryNewConnectorImpl.this.m_port.set(null);
                        }
                        ConnectionFactoryNewConnectorImpl.this.connect(remoteAddress, (IoSessionInitializer<? extends ConnectFuture>)init, handler);
                    }
                    catch (RuntimeIoException e) {
                        LogUtils.debugf((Object)this, (Throwable)e, (String)"Exception of type %s caught, disposing of connector: %s", (Object[])new Object[]{((Object)((Object)e)).getClass().getName(), Thread.currentThread().getName()});
                        connector.dispose();
                    }
                }
            }
        };
    }

    @Override
    public ConnectFuture reConnect(SocketAddress remoteAddress, IoSessionInitializer<? extends ConnectFuture> init, IoHandler handler) {
        return this.connect(remoteAddress, init, handler);
    }

    @Override
    protected void dispose() {
    }
}

