/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.minion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.minion.OnmsMinionProperty;

@Entity
@Table(name="minions")
@XmlRootElement(name="minion")
@XmlAccessorType(value=XmlAccessType.NONE)
public class OnmsMinion {
    @XmlID
    @XmlAttribute(name="id")
    private String m_id;
    @XmlElement(name="location")
    private String m_location;
    @XmlElement(name="status")
    private String m_status;
    @XmlElement(name="date")
    private Date m_lastUpdated;
    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    private List<OnmsMinionProperty> m_properties = new ArrayList<OnmsMinionProperty>();

    public OnmsMinion() {
    }

    public OnmsMinion(String id, String location, String status, Date lastUpdated) {
        this.m_id = id;
        this.m_location = location;
        this.m_status = status;
        this.m_lastUpdated = lastUpdated;
    }

    @Id
    @Column(name="id", nullable=false, length=36, unique=true)
    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    @Column(name="location", nullable=false)
    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    @Column(name="status")
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @Column(name="last_updated")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastUpdated() {
        return this.m_lastUpdated;
    }

    public void setLastUpdated(Date lastUpdated) {
        this.m_lastUpdated = lastUpdated;
    }

    @Transient
    public Map<String, String> getProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (OnmsMinionProperty prop : this.getMinionProperties()) {
            properties.put(prop.getKey(), prop.getValue());
        }
        return properties;
    }

    public OnmsMinionProperty getProperty(String key) {
        for (OnmsMinionProperty prop : this.getMinionProperties()) {
            if (!prop.getKey().equals(key)) continue;
            return prop;
        }
        return null;
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        for (OnmsMinionProperty prop : this.getMinionProperties()) {
            if (!prop.getKey().equals(key)) continue;
            prop.setValue(value);
            return;
        }
        OnmsMinionProperty prop = new OnmsMinionProperty(this, key, value);
        this.m_properties.add(prop);
    }

    public boolean removeProperty(OnmsMinionProperty prop) {
        return this.m_properties.remove(prop);
    }

    public OnmsMinionProperty removeProperty(String key) {
        OnmsMinionProperty removed = null;
        for (OnmsMinionProperty prop : this.getMinionProperties()) {
            if (!prop.getKey().equals(key)) continue;
            removed = prop;
            break;
        }
        if (removed != null) {
            this.m_properties.remove(removed);
        }
        return removed;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="minion", fetch=FetchType.EAGER)
    protected List<OnmsMinionProperty> getMinionProperties() {
        if (this.m_properties == null) {
            return Collections.emptyList();
        }
        return this.m_properties;
    }

    protected void setMinionProperties(List<OnmsMinionProperty> properties) {
        this.m_properties = properties;
    }

    public String toString() {
        return "OnmsMinion [id=" + this.m_id + ", location=" + this.m_location + ", status=" + this.m_status + ", lastUpdated=" + this.m_lastUpdated + ", properties=" + this.m_properties + "]";
    }
}

