/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="vlan")
@Entity
@Table(name="vlan", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "vlanId"})})
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class OnmsVlan
implements Comparable<OnmsVlan> {
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_vlanId;
    private String m_vlanName;
    private VlanType m_vlanType = VlanType.UNKNOWN;
    private VlanStatus m_vlanStatus = VlanStatus.UNKNOWN;
    private OnmsArpInterface.StatusType m_status = OnmsArpInterface.StatusType.UNKNOWN;
    private Date m_lastPollTime;

    public OnmsVlan() {
    }

    public OnmsVlan(int index, String name, VlanStatus status, VlanType type) {
        this.m_vlanId = index;
        this.m_vlanName = name;
        this.m_vlanStatus = status;
        this.m_vlanType = type;
    }

    public OnmsVlan(int index, String name, VlanStatus status) {
        this.m_vlanId = index;
        this.m_vlanName = name;
        this.m_vlanStatus = status;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Integer getVlanId() {
        return this.m_vlanId;
    }

    public void setVlanId(Integer vlanId) {
        this.m_vlanId = vlanId;
    }

    @XmlAttribute(name="name")
    @Column(nullable=false)
    public String getVlanName() {
        return this.m_vlanName;
    }

    public void setVlanName(String vlanName) {
        this.m_vlanName = vlanName;
    }

    @XmlAttribute(name="type")
    @Column
    public VlanType getVlanType() {
        return this.m_vlanType;
    }

    public void setVlanType(VlanType vlanType) {
        this.m_vlanType = vlanType;
    }

    @XmlAttribute
    @Column
    public VlanStatus getVlanStatus() {
        return this.m_vlanStatus;
    }

    public void setVlanStatus(VlanStatus vlanStatus) {
        this.m_vlanStatus = vlanStatus;
    }

    @XmlAttribute
    @Column(nullable=false)
    public OnmsArpInterface.StatusType getStatus() {
        return this.m_status;
    }

    public void setStatus(OnmsArpInterface.StatusType status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("dbId", (Object)this.m_id).append("node", (Object)this.m_node).append("id", (Object)this.m_vlanId).append("name", (Object)this.m_vlanName).append("type", (Object)this.m_vlanType).append("status", (Object)this.m_vlanStatus).append("dbStatus", (Object)this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }

    @Override
    public int compareTo(OnmsVlan o) {
        return new CompareToBuilder().append((Object)this.m_node, (Object)o.m_node).append((Object)this.m_vlanId, (Object)o.m_vlanId).append((Object)this.m_vlanName, (Object)o.m_vlanName).append((Object)this.m_vlanStatus, (Object)o.m_vlanStatus).append((Object)this.m_status, (Object)o.m_status).append((Object)this.m_lastPollTime, (Object)o.m_lastPollTime).toComparison();
    }

    @Embeddable
    public static class VlanType
    implements Comparable<VlanType>,
    Serializable {
        private static final long serialVersionUID = -7012640218990540145L;
        public static final int VLAN_TYPE_UNKNOWN = 0;
        public static final int VLAN_TYPE_VTP_ETHERNET = 1;
        public static final int VLAN_TYPE_VTP_FDDI = 2;
        public static final int VLAN_TYPE_VTP_TOKENRING = 3;
        public static final int VLAN_TYPE_VTP_FDDINET = 4;
        public static final int VLAN_TYPE_VTP_TRNET = 5;
        public static final int VLAN_TYPE_VTP_DEPRECATED = 6;
        public static final int VLAN_TYPE_EXTREME_LAYERTWO = 7;
        public static final int THREECOM_STARTING_INDEX = 7;
        public static final int VLAN_TYPE_THREECOM_vlanLayer2 = 8;
        public static final int VLAN_TYPE_THREECOM_vlanUnspecifiedProtocols = 9;
        public static final int VLAN_TYPE_THREECOM_vlanIPProtocol = 10;
        public static final int VLAN_TYPE_THREECOM_vlanIPXProtocol = 11;
        public static final int VLAN_TYPE_THREECOM_vlanAppleTalkProtocol = 12;
        public static final int VLAN_TYPE_THREECOM_vlanXNSProtocol = 13;
        public static final int VLAN_TYPE_THREECOM_vlanISOProtocol = 14;
        public static final int VLAN_TYPE_THREECOM_vlanDECNetProtocol = 15;
        public static final int VLAN_TYPE_THREECOM_vlanNetBIOSProtocol = 16;
        public static final int VLAN_TYPE_THREECOM_vlanSNAProtocol = 17;
        public static final int VLAN_TYPE_THREECOM_vlanVINESProtocol = 18;
        public static final int VLAN_TYPE_THREECOM_vlanX25Protocol = 19;
        public static final int VLAN_TYPE_THREECOM_vlanIGMPProtocol = 20;
        public static final int VLAN_TYPE_THREECOM_vlanSessionLayer = 21;
        public static final int VLAN_TYPE_THREECOM_vlanNetBeui = 22;
        public static final int VLAN_TYPE_THREECOM_vlanLayeredProtocols = 23;
        public static final int VLAN_TYPE_THREECOM_vlanIPXIIProtocol = 24;
        public static final int VLAN_TYPE_THREECOM_vlanIPX8022Protocol = 25;
        public static final int VLAN_TYPE_THREECOM_vlanIPX8023Protocol = 26;
        public static final int VLAN_TYPE_THREECOM_vlanIPX8022SNAPProtocol = 27;
        private static final Integer[] s_order = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27};
        private Integer m_vlanType;
        private static final Map<Integer, String> vlanTypeMap = new HashMap<Integer, String>();
        public static final VlanType UNKNOWN;
        public static final VlanType CISCO_VTP_ETHERNET;
        public static final VlanType CISCO_VTP_FDDI;
        public static final VlanType CISCO_VTP_TOKENRING;
        public static final VlanType CISCO_VTP_FDDINET;
        public static final VlanType CISCO_VTP_TRNET;
        public static final VlanType CISCO_VTP_DEPRECATED;
        public static final VlanType EXTREME_LAYER2;
        public static final VlanType THREECOM_vlanLayer2;
        public static final VlanType THREECOM_vlanUnspecifiedProtocols;
        public static final VlanType THREECOM_vlanIPProtocol;
        public static final VlanType THREECOM_vlanIPXProtocol;
        public static final VlanType THREECOM_vlanAppleTalkProtocol;
        public static final VlanType THREECOM_vlanXNSProtocol;
        public static final VlanType THREECOM_vlanISOProtocol;
        public static final VlanType THREECOM_vlanDECNetProtocol;
        public static final VlanType THREECOM_vlanNetBIOSProtocol;
        public static final VlanType THREECOM_vlanSNAProtocol;
        public static final VlanType THREECOM_vlanVINESProtocol;
        public static final VlanType THREECOM_vlanX25Protocol;
        public static final VlanType THREECOM_vlanIGMPProtocol;
        public static final VlanType THREECOM_vlanSessionLayer;
        public static final VlanType THREECOM_vlanNetBeui;
        public static final VlanType THREECOM_vlanLayeredProtocols;
        public static final VlanType THREECOM_vlanIPXIIProtocol;
        public static final VlanType THREECOM_vlanIPX8022Protocol;
        public static final VlanType THREECOM_vlanIPX8023Protocol;
        public static final VlanType THREECOM_vlanIPX8022SNAPProtocol;

        private VlanType() {
        }

        public VlanType(Integer vlanType) {
            this.m_vlanType = vlanType;
        }

        @Column(name="vlanType")
        public Integer getIntCode() {
            return this.m_vlanType;
        }

        public void setIntCode(Integer vlanType) {
            this.m_vlanType = vlanType;
        }

        @Override
        public int compareTo(VlanType o) {
            return VlanType.getIndex(this.m_vlanType) - VlanType.getIndex(o.m_vlanType);
        }

        private static int getIndex(Integer code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal vlanType code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof VlanType) {
                return this.m_vlanType.intValue() == ((VlanType)o).m_vlanType.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_vlanType);
        }

        public static final VlanType get(Integer code) {
            if (code == null) {
                return UNKNOWN;
            }
            switch (code) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return CISCO_VTP_ETHERNET;
                }
                case 2: {
                    return CISCO_VTP_FDDI;
                }
                case 3: {
                    return CISCO_VTP_TOKENRING;
                }
                case 4: {
                    return CISCO_VTP_FDDINET;
                }
                case 5: {
                    return CISCO_VTP_TRNET;
                }
                case 6: {
                    return CISCO_VTP_DEPRECATED;
                }
                case 7: {
                    return EXTREME_LAYER2;
                }
                case 8: {
                    return THREECOM_vlanLayer2;
                }
                case 9: {
                    return THREECOM_vlanUnspecifiedProtocols;
                }
                case 10: {
                    return THREECOM_vlanIPProtocol;
                }
                case 11: {
                    return THREECOM_vlanIPXProtocol;
                }
                case 12: {
                    return THREECOM_vlanAppleTalkProtocol;
                }
                case 13: {
                    return THREECOM_vlanXNSProtocol;
                }
                case 14: {
                    return THREECOM_vlanISOProtocol;
                }
                case 15: {
                    return THREECOM_vlanDECNetProtocol;
                }
                case 16: {
                    return THREECOM_vlanNetBIOSProtocol;
                }
                case 17: {
                    return THREECOM_vlanSNAProtocol;
                }
                case 18: {
                    return THREECOM_vlanVINESProtocol;
                }
                case 19: {
                    return THREECOM_vlanX25Protocol;
                }
                case 20: {
                    return THREECOM_vlanIGMPProtocol;
                }
                case 21: {
                    return THREECOM_vlanSessionLayer;
                }
                case 22: {
                    return THREECOM_vlanNetBeui;
                }
                case 23: {
                    return THREECOM_vlanLayeredProtocols;
                }
                case 24: {
                    return THREECOM_vlanIPXIIProtocol;
                }
                case 25: {
                    return THREECOM_vlanIPX8022Protocol;
                }
                case 26: {
                    return THREECOM_vlanIPX8023Protocol;
                }
                case 27: {
                    return THREECOM_vlanIPX8022SNAPProtocol;
                }
            }
            throw new IllegalArgumentException("Cannot create vlanType from code " + code);
        }

        public static String getVlanTypeString(Integer code) {
            if (vlanTypeMap.containsKey(code)) {
                return vlanTypeMap.get(code);
            }
            return null;
        }

        static {
            vlanTypeMap.put(0, "Unknown");
            vlanTypeMap.put(1, "Ethernet");
            vlanTypeMap.put(2, "CiscoVtp/FDDI");
            vlanTypeMap.put(3, "CiscoVtp/TokenRing");
            vlanTypeMap.put(4, "CiscoVtp/FDDINet");
            vlanTypeMap.put(5, "CiscoVtp/TRNet");
            vlanTypeMap.put(6, "CiscoVtp/Deprecated");
            vlanTypeMap.put(7, "Extreme/LayerTwo");
            vlanTypeMap.put(8, "3com/vlanLayer2");
            vlanTypeMap.put(9, "3com/vlanUnspecifiedProtocols");
            vlanTypeMap.put(10, "3com/vlanIPProtocol");
            vlanTypeMap.put(11, "3com/vlanIPXProtocol");
            vlanTypeMap.put(12, "3com/vlanAppleTalkProtocol");
            vlanTypeMap.put(13, "3com/vlanXNSProtocol");
            vlanTypeMap.put(14, "3com/vlanISOProtocol");
            vlanTypeMap.put(15, "3com/vlanDECNetProtocol");
            vlanTypeMap.put(16, "3com/vlanNetBIOSProtocol");
            vlanTypeMap.put(17, "3com/vlanSNAProtocol");
            vlanTypeMap.put(18, "3com/vlanVINESProtocol");
            vlanTypeMap.put(19, "3com/vlanX25Protocol");
            vlanTypeMap.put(20, "3com/vlanIGMPProtocol");
            vlanTypeMap.put(21, "3com/vlanSessionLayer");
            vlanTypeMap.put(22, "3com/vlanNetBeui");
            vlanTypeMap.put(23, "3com/vlanLayeredProtocols");
            vlanTypeMap.put(24, "3com/vlanIPXIIProtocol");
            vlanTypeMap.put(25, "3com/vlanIPX8022Protocol");
            vlanTypeMap.put(26, "3com/vlanIPX8023Protocol");
            vlanTypeMap.put(27, "3com/vlanIPX8022SNAPProtocol");
            UNKNOWN = new VlanType(0);
            CISCO_VTP_ETHERNET = new VlanType(1);
            CISCO_VTP_FDDI = new VlanType(2);
            CISCO_VTP_TOKENRING = new VlanType(3);
            CISCO_VTP_FDDINET = new VlanType(4);
            CISCO_VTP_TRNET = new VlanType(5);
            CISCO_VTP_DEPRECATED = new VlanType(6);
            EXTREME_LAYER2 = new VlanType(7);
            THREECOM_vlanLayer2 = new VlanType(8);
            THREECOM_vlanUnspecifiedProtocols = new VlanType(9);
            THREECOM_vlanIPProtocol = new VlanType(10);
            THREECOM_vlanIPXProtocol = new VlanType(11);
            THREECOM_vlanAppleTalkProtocol = new VlanType(12);
            THREECOM_vlanXNSProtocol = new VlanType(13);
            THREECOM_vlanISOProtocol = new VlanType(14);
            THREECOM_vlanDECNetProtocol = new VlanType(15);
            THREECOM_vlanNetBIOSProtocol = new VlanType(16);
            THREECOM_vlanSNAProtocol = new VlanType(17);
            THREECOM_vlanVINESProtocol = new VlanType(18);
            THREECOM_vlanX25Protocol = new VlanType(19);
            THREECOM_vlanIGMPProtocol = new VlanType(20);
            THREECOM_vlanSessionLayer = new VlanType(21);
            THREECOM_vlanNetBeui = new VlanType(22);
            THREECOM_vlanLayeredProtocols = new VlanType(23);
            THREECOM_vlanIPXIIProtocol = new VlanType(24);
            THREECOM_vlanIPX8022Protocol = new VlanType(25);
            THREECOM_vlanIPX8023Protocol = new VlanType(26);
            THREECOM_vlanIPX8022SNAPProtocol = new VlanType(27);
        }
    }

    @Embeddable
    public static class VlanStatus
    implements Comparable<VlanStatus>,
    Serializable {
        private static final long serialVersionUID = -5676188320482765289L;
        public static final int VLAN_STATUS_UNKNOWN = 0;
        public static final int CISCOVTP_VLAN_STATUS_OPERATIONAL = 1;
        public static final int CISCOVTP_VLAN_STATUS_SUSPENDED = 2;
        public static final int CISCOVTP_VLAN_STATUS_mtuTooBigForDevice = 3;
        public static final int CISCOVTP_VLAN_STATUS_mtuTooBigForTrunk = 4;
        public static final int ROWSTATUS_STARTING_INDEX = 4;
        public static final int SNMPV2C_ROWSTATUS_ACTIVE = 5;
        public static final int SNMPV2C_ROWSTATUS_NOTINSERVICE = 6;
        public static final int SNMPV2C_ROWSTATUS_NOTREADY = 7;
        public static final int SNMPV2C_ROWSTATUS_CREATEANDGO = 8;
        public static final int SNMPV2C_ROWSTATUS_CREATEANDWAIT = 9;
        public static final int SNMPV2C_ROWSTATUS_DESTROY = 10;
        private static final Integer[] s_order = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        private Integer m_vlanStatus;
        private static final Map<Integer, String> vlanStatusMap = new HashMap<Integer, String>();
        public static final VlanStatus UNKNOWN;
        public static final VlanStatus CISCOVTP_OPERATIONAL;
        public static final VlanStatus CISCOVTP_SUSPENDED;
        public static final VlanStatus CISCOVTP_mtuTooBigForDevice;
        public static final VlanStatus CISCOVTP_mtuTooBigForTrunk;
        public static final VlanStatus ROWSTATUS_ACTIVE;
        public static final VlanStatus ROWSTATUS_NOTINSERVICE;
        public static final VlanStatus ROWSTATUS_NOTREADY;
        public static final VlanStatus ROWSTATUS_CREATEANDGO;
        public static final VlanStatus ROWSTATUS_CREATEANDWAIT;
        public static final VlanStatus ROWSTATUS_DESTROY;

        private VlanStatus() {
        }

        public VlanStatus(Integer vlanType) {
            this.m_vlanStatus = vlanType;
        }

        @Column(name="vlanStatus")
        public Integer getIntCode() {
            return this.m_vlanStatus;
        }

        public void setIntCode(Integer vlanType) {
            this.m_vlanStatus = vlanType;
        }

        @Override
        public int compareTo(VlanStatus o) {
            return VlanStatus.getIndex(this.m_vlanStatus) - VlanStatus.getIndex(o.m_vlanStatus);
        }

        private static int getIndex(Integer code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal vlanStatus code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof VlanStatus) {
                return this.m_vlanStatus.intValue() == ((VlanStatus)o).m_vlanStatus.intValue();
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_vlanStatus);
        }

        public static VlanStatus get(Integer code) {
            if (code == null) {
                return UNKNOWN;
            }
            switch (code) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return CISCOVTP_OPERATIONAL;
                }
                case 2: {
                    return CISCOVTP_SUSPENDED;
                }
                case 3: {
                    return CISCOVTP_mtuTooBigForDevice;
                }
                case 4: {
                    return CISCOVTP_mtuTooBigForTrunk;
                }
                case 5: {
                    return ROWSTATUS_ACTIVE;
                }
                case 6: {
                    return ROWSTATUS_NOTINSERVICE;
                }
                case 7: {
                    return ROWSTATUS_NOTREADY;
                }
                case 8: {
                    return ROWSTATUS_CREATEANDGO;
                }
                case 9: {
                    return ROWSTATUS_CREATEANDWAIT;
                }
                case 10: {
                    return ROWSTATUS_DESTROY;
                }
            }
            throw new IllegalArgumentException("Cannot create vlanStatus from code " + code);
        }

        public static String getVlanStatusString(Integer code) {
            if (vlanStatusMap.containsKey(code)) {
                return vlanStatusMap.get(code);
            }
            return null;
        }

        static {
            vlanStatusMap.put(0, "unknown");
            vlanStatusMap.put(1, "operational");
            vlanStatusMap.put(2, "ciscovtp/suspended");
            vlanStatusMap.put(3, "ciscovtp/mtuTooBigForDevice");
            vlanStatusMap.put(4, "ciscovtp/mtuTooBigForTrunk");
            vlanStatusMap.put(5, "rowStatus/active");
            vlanStatusMap.put(6, "rowStatus/notInService");
            vlanStatusMap.put(7, "rowStatus/notReady");
            vlanStatusMap.put(8, "rowStatus/createAndGo");
            vlanStatusMap.put(9, "rowStatus/createAndWait");
            vlanStatusMap.put(10, "rowStatus/destroy");
            UNKNOWN = new VlanStatus(0);
            CISCOVTP_OPERATIONAL = new VlanStatus(1);
            CISCOVTP_SUSPENDED = new VlanStatus(2);
            CISCOVTP_mtuTooBigForDevice = new VlanStatus(3);
            CISCOVTP_mtuTooBigForTrunk = new VlanStatus(4);
            ROWSTATUS_ACTIVE = new VlanStatus(5);
            ROWSTATUS_NOTINSERVICE = new VlanStatus(6);
            ROWSTATUS_NOTREADY = new VlanStatus(7);
            ROWSTATUS_CREATEANDGO = new VlanStatus(8);
            ROWSTATUS_CREATEANDWAIT = new VlanStatus(9);
            ROWSTATUS_DESTROY = new VlanStatus(10);
        }
    }
}

