/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.hibernate.annotations.Type;
import org.opennms.netmgt.model.OnmsArpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.bind.StatusTypeXmlAdapter;

@XmlRootElement(name="link")
@Entity
@Table(name="datalinkinterface")
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(value={"hibernateLazyInitializer", "handler"})
public class DataLinkInterface
implements Serializable,
Comparable<DataLinkInterface> {
    private static final long serialVersionUID = 2497320585094892071L;
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_ifIndex;
    private Integer m_nodeParentId;
    private Integer m_parentIfIndex;
    private OnmsArpInterface.StatusType m_status;
    private Integer m_linkTypeId;
    private Date m_lastPollTime;
    private String m_source = "linkd";
    private DiscoveryProtocol m_protocol;
    private Integer m_nodeId = null;

    public DataLinkInterface() {
    }

    public DataLinkInterface(OnmsNode node, int ifIndex, int nodeParentId, int parentIfIndex, OnmsArpInterface.StatusType status, Date lastPollTime) {
        this.m_node = node;
        this.m_ifIndex = ifIndex;
        this.m_nodeParentId = nodeParentId;
        this.m_parentIfIndex = parentIfIndex;
        this.m_status = status;
        this.m_lastPollTime = lastPollTime;
        this.m_linkTypeId = -1;
    }

    public DataLinkInterface(OnmsNode node, int ifIndex, int nodeParentId, int parentIfIndex, Date lastPollTime) {
        this.m_node = node;
        this.m_ifIndex = ifIndex;
        this.m_nodeParentId = nodeParentId;
        this.m_parentIfIndex = parentIfIndex;
        this.m_status = OnmsArpInterface.StatusType.UNKNOWN;
        this.m_lastPollTime = lastPollTime;
        this.m_linkTypeId = -1;
    }

    @XmlTransient
    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getDataLinkInterfaceId() {
        return this.getId() == null ? null : this.getId().toString();
    }

    public void setDataLinkInterfaceId(String id) {
        this.m_id = Integer.valueOf(id);
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlTransient
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Transient
    @XmlElement(name="nodeId")
    public Integer getNodeId() {
        return this.m_node == null ? this.m_nodeId : this.m_node.getId();
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    @XmlElement(name="ifIndex")
    @Column(name="ifindex", nullable=false)
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @XmlElement(name="nodeParentId")
    @Column(name="nodeparentid", nullable=false)
    public Integer getNodeParentId() {
        return this.m_nodeParentId;
    }

    public void setNodeParentId(Integer nodeParentId) {
        this.m_nodeParentId = nodeParentId;
    }

    @XmlElement(name="parentIfIndex")
    @Column(name="parentifindex", nullable=false)
    public Integer getParentIfIndex() {
        return this.m_parentIfIndex;
    }

    public void setParentIfIndex(Integer parentIfIndex) {
        this.m_parentIfIndex = parentIfIndex;
    }

    @XmlAttribute(name="status")
    @Type(type="org.opennms.netmgt.model.StatusTypeUserType")
    @XmlJavaTypeAdapter(value=StatusTypeXmlAdapter.class)
    @Column(name="status", length=1, nullable=false)
    public OnmsArpInterface.StatusType getStatus() {
        return this.m_status;
    }

    public void setStatus(OnmsArpInterface.StatusType status) {
        this.m_status = status;
    }

    @XmlElement(name="linkTypeId")
    @Column(name="linktypeid", nullable=true)
    public Integer getLinkTypeId() {
        return this.m_linkTypeId;
    }

    public void setLinkTypeId(Integer linkTypeId) {
        this.m_linkTypeId = linkTypeId;
    }

    @Enumerated(value=EnumType.STRING)
    @XmlElement(name="protocol")
    @Column(name="protocol", length=31, nullable=true)
    public DiscoveryProtocol getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(DiscoveryProtocol protocol) {
        this.m_protocol = protocol;
    }

    @XmlElement(name="lastPollTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastpolltime", nullable=false)
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @XmlAttribute(name="source")
    @Column(name="source", nullable=false)
    public String getSource() {
        return this.m_source;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    @Override
    public int compareTo(DataLinkInterface o) {
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).append((Object)this.getNode(), (Object)o.getNode()).append((Object)this.getIfIndex(), (Object)o.getIfIndex()).append((Object)this.getSource(), (Object)o.getSource()).append((Object)this.getNodeParentId(), (Object)o.getNodeParentId()).append((Object)this.getParentIfIndex(), (Object)o.getParentIfIndex()).append((Object)this.getStatus(), (Object)o.getStatus()).append((Object)this.getLastPollTime(), (Object)o.getLastPollTime()).append((Object)this.getLinkTypeId(), (Object)o.getLinkTypeId()).toComparison();
    }

    public String toString() {
        return "DataLinkInterface [id=" + this.m_id + ", nodeId=" + this.m_node.getId() + ", ifIndex=" + this.m_ifIndex + ", nodeParentId=" + this.m_nodeParentId + ", parentIfIndex=" + this.m_parentIfIndex + ", status=" + this.m_status + ", linkTypeId=" + this.m_linkTypeId + ", lastPollTime=" + this.m_lastPollTime + ", source=" + this.m_source + ", protocol=" + (Object)((Object)this.m_protocol) + "]";
    }

    public static enum DiscoveryProtocol {
        bridge,
        cdp,
        iproute,
        lldp,
        ospf,
        isis,
        wifi,
        NA;

    }
}

