/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.events.AddEventVisitor;
import org.opennms.netmgt.model.events.DeleteEventVisitor;
import org.opennms.netmgt.model.events.EventForwarder;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="ipInterface")
@Entity
@Table(name="ipInterface")
public class OnmsIpInterface
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = 7750043250236397014L;
    private Integer m_id;
    private InetAddress m_ipAddress;
    private String m_ipHostName;
    private String m_isManaged;
    private PrimaryType m_isSnmpPrimary = PrimaryType.NOT_ELIGIBLE;
    private Date m_ipLastCapsdPoll;
    private OnmsNode m_node;
    private Set<OnmsMonitoredService> m_monitoredServices = new HashSet<OnmsMonitoredService>();
    private OnmsSnmpInterface m_snmpInterface;

    public OnmsIpInterface() {
    }

    public OnmsIpInterface(String ipAddr, OnmsNode node) {
        this(InetAddressUtils.getInetAddress((String)ipAddr), node);
    }

    public OnmsIpInterface(InetAddress ipAddr, OnmsNode node) {
        this.m_ipAddress = ipAddr;
        this.m_node = node;
        if (node != null) {
            node.getIpInterfaces().add(this);
        }
    }

    @Id
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Transient
    public String getIpAddressAsString() {
        return InetAddressUtils.toIpAddrString((InetAddress)this.m_ipAddress);
    }

    @Transient
    @XmlAttribute(name="ifIndex")
    public Integer getIfIndex() {
        if (this.m_snmpInterface == null) {
            return null;
        }
        return this.m_snmpInterface.getIfIndex();
    }

    public void setIfIndex(Integer ifindex) {
        if (this.m_snmpInterface == null) {
            throw new IllegalStateException("Cannot set ifIndex if snmpInterface relation isn't setup");
        }
        this.m_snmpInterface.setIfIndex(ifindex);
    }

    @Column(name="ipHostName", length=256)
    @XmlElement(name="hostName")
    public String getIpHostName() {
        return this.m_ipHostName;
    }

    public void setIpHostName(String iphostname) {
        this.m_ipHostName = iphostname;
    }

    @Column(name="isManaged", length=1)
    @XmlAttribute(name="isManaged")
    public String getIsManaged() {
        return this.m_isManaged;
    }

    public void setIsManaged(String ismanaged) {
        this.m_isManaged = ismanaged;
    }

    @Transient
    public boolean isManaged() {
        return "M".equals(this.getIsManaged());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ipLastCapsdPoll")
    @XmlElement(name="lastCapsdPoll")
    public Date getIpLastCapsdPoll() {
        return this.m_ipLastCapsdPoll;
    }

    public void setIpLastCapsdPoll(Date iplastcapsdpoll) {
        this.m_ipLastCapsdPoll = iplastcapsdpoll;
    }

    @Transient
    @XmlAttribute(name="snmpPrimary")
    public String getPrimaryString() {
        return this.m_isSnmpPrimary == null ? null : this.m_isSnmpPrimary.toString();
    }

    public void setPrimaryString(String primaryType) {
        this.m_isSnmpPrimary = new PrimaryType(primaryType.charAt(0));
    }

    @Column(name="isSnmpPrimary", length=1)
    @XmlTransient
    public PrimaryType getIsSnmpPrimary() {
        return this.m_isSnmpPrimary;
    }

    public void setIsSnmpPrimary(PrimaryType issnmpprimary) {
        this.m_isSnmpPrimary = issnmpprimary;
    }

    @Transient
    public boolean isPrimary() {
        return this.m_isSnmpPrimary.equals(PrimaryType.PRIMARY);
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlTransient
    @OneToMany(mappedBy="ipInterface")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<OnmsMonitoredService> getMonitoredServices() {
        return this.m_monitoredServices;
    }

    public void setMonitoredServices(Set<OnmsMonitoredService> ifServices) {
        this.m_monitoredServices = ifServices;
    }

    @XmlElement(name="snmpInterface")
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="snmpInterfaceId")
    public OnmsSnmpInterface getSnmpInterface() {
        return this.m_snmpInterface;
    }

    public void setSnmpInterface(OnmsSnmpInterface snmpInterface) {
        this.m_snmpInterface = snmpInterface;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("ipAddr", (Object)InetAddressUtils.str((InetAddress)this.m_ipAddress)).append("ipHostName", (Object)this.m_ipHostName).append("isManaged", (Object)this.m_isManaged).append("isSnmpPrimary", (Object)this.m_isSnmpPrimary).append("ipLastCapsdPoll", (Object)this.m_ipLastCapsdPoll).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitIpInterface(this);
        for (OnmsMonitoredService monSvc : this.getMonitoredServices()) {
            monSvc.visit(visitor);
        }
        visitor.visitIpInterfaceComplete(this);
    }

    @Column(name="ipAddr")
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(InetAddress ipaddr) {
        this.m_ipAddress = ipaddr;
    }

    @Transient
    @XmlAttribute(name="isDown")
    public boolean isDown() {
        boolean down = true;
        for (OnmsMonitoredService svc : this.m_monitoredServices) {
            if (svc.isDown()) continue;
            return !down;
        }
        return down;
    }

    @Transient
    @XmlAttribute
    public int getMonitoredServiceCount() {
        return this.m_monitoredServices.size();
    }

    public OnmsMonitoredService getMonitoredServiceByServiceType(String svcName) {
        for (OnmsMonitoredService monSvc : this.getMonitoredServices()) {
            if (!monSvc.getServiceType().getName().equals(svcName)) continue;
            return monSvc;
        }
        return null;
    }

    public void mergeInterfaceAttributes(OnmsIpInterface scannedIface) {
        if (OnmsIpInterface.hasNewValue(scannedIface.getIsManaged(), this.getIsManaged())) {
            this.setIsManaged(scannedIface.getIsManaged());
        }
        if (OnmsIpInterface.hasNewCollectionTypeValue(scannedIface.getIsSnmpPrimary(), this.getIsSnmpPrimary())) {
            this.setIsSnmpPrimary(scannedIface.getIsSnmpPrimary());
        }
        if (OnmsIpInterface.hasNewValue(scannedIface.getIpHostName(), this.getIpHostName())) {
            this.setIpHostName(scannedIface.getIpHostName());
        }
        if (OnmsIpInterface.hasNewValue(scannedIface.getIpLastCapsdPoll(), this.getIpLastCapsdPoll())) {
            this.setIpLastCapsdPoll(scannedIface.getIpLastCapsdPoll());
        }
    }

    protected static boolean hasNewCollectionTypeValue(PrimaryType newVal, PrimaryType existingVal) {
        return newVal != null && !newVal.equals(existingVal) && newVal != PrimaryType.NOT_ELIGIBLE;
    }

    public void mergeMonitoredServices(OnmsIpInterface scannedIface, EventForwarder eventForwarder, boolean deleteMissing) {
        HashMap<OnmsServiceType, OnmsMonitoredService> serviceTypeMap = new HashMap<OnmsServiceType, OnmsMonitoredService>();
        for (OnmsMonitoredService svc : scannedIface.getMonitoredServices()) {
            serviceTypeMap.put(svc.getServiceType(), svc);
        }
        Iterator<OnmsMonitoredService> it = this.getMonitoredServices().iterator();
        while (it.hasNext()) {
            OnmsMonitoredService svc;
            svc = it.next();
            OnmsMonitoredService imported = (OnmsMonitoredService)serviceTypeMap.get(svc.getServiceType());
            if (imported == null) {
                if (deleteMissing) {
                    it.remove();
                    svc.visit(new DeleteEventVisitor(eventForwarder));
                }
            } else {
                svc.mergeServiceAttributes(imported);
            }
            serviceTypeMap.remove(svc.getServiceType());
        }
        Collection newServices = serviceTypeMap.values();
        for (OnmsMonitoredService svc : newServices) {
            svc.setIpInterface(this);
            this.getMonitoredServices().add(svc);
            svc.visit(new AddEventVisitor(eventForwarder));
        }
    }

    public void updateSnmpInterface(OnmsIpInterface scannedIface) {
        if (!OnmsIpInterface.hasNewValue(scannedIface.getIfIndex(), this.getIfIndex())) {
            return;
        }
        if (scannedIface.getSnmpInterface() == null) {
            this.setSnmpInterface(null);
        } else {
            OnmsSnmpInterface snmpIface = this.getNode().getSnmpInterfaceWithIfIndex(scannedIface.getIfIndex());
            this.setSnmpInterface(snmpIface);
        }
    }

    public void mergeInterface(OnmsIpInterface scannedIface, EventForwarder eventForwarder, boolean deleteMissing) {
        this.mergeInterfaceAttributes(scannedIface);
        this.updateSnmpInterface(scannedIface);
        this.mergeMonitoredServices(scannedIface, eventForwarder, deleteMissing);
    }

    @Embeddable
    public static class PrimaryType
    implements Comparable<PrimaryType>,
    Serializable {
        private static final long serialVersionUID = -647348487361201657L;
        private static final char[] s_order = new char[]{'N', 'S', 'P'};
        private char m_collType;
        public static final PrimaryType PRIMARY = new PrimaryType('P');
        public static final PrimaryType SECONDARY = new PrimaryType('S');
        public static final PrimaryType NOT_ELIGIBLE = new PrimaryType('N');

        private PrimaryType() {
            this('N');
        }

        private PrimaryType(char collType) {
            this.m_collType = collType;
        }

        @Column(name="isSnmpPrimary")
        public char getCharCode() {
            return this.m_collType;
        }

        public void setCharCode(char collType) {
            this.m_collType = collType;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof PrimaryType) {
                return this.compareTo((PrimaryType)o) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(PrimaryType collType) {
            return PrimaryType.getIndex(this.m_collType) - PrimaryType.getIndex(collType.m_collType);
        }

        private static int getIndex(char code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal collType code '" + code + "'");
        }

        public String toString() {
            return String.valueOf(this.m_collType);
        }

        public boolean isLessThan(PrimaryType collType) {
            return this.compareTo(collType) < 0;
        }

        public boolean isGreaterThan(PrimaryType collType) {
            return this.compareTo(collType) > 0;
        }

        public PrimaryType max(PrimaryType collType) {
            return this.isLessThan(collType) ? collType : this;
        }

        public PrimaryType min(PrimaryType collType) {
            return this.isLessThan(collType) ? this : collType;
        }

        public static PrimaryType get(char code) {
            switch (code) {
                case 'P': {
                    return PRIMARY;
                }
                case 'S': {
                    return SECONDARY;
                }
                case 'N': {
                    return NOT_ELIGIBLE;
                }
            }
            throw new IllegalArgumentException("Cannot create collType from code " + code);
        }

        public static PrimaryType get(String code) {
            if (code == null) {
                return NOT_ELIGIBLE;
            }
            if ((code = code.trim()).length() < 1) {
                return NOT_ELIGIBLE;
            }
            if (code.length() > 1) {
                throw new IllegalArgumentException("Cannot convert string " + code + " to a collType");
            }
            return PrimaryType.get(code.charAt(0));
        }
    }
}

