/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.net.InetAddress;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Type;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="atInterface")
@Entity
@Table(name="atInterface", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "ipAddr", "atPhysAddr"})})
public class OnmsAtInterface {
    private Integer m_id;
    private OnmsNode m_node;
    private InetAddress m_ipAddress;
    private String m_macAddress;
    private Character m_status;
    private Integer m_sourceNodeId;
    private Integer m_ifIndex;
    private Date m_lastPollTime;

    OnmsAtInterface() {
    }

    public OnmsAtInterface(OnmsNode node, InetAddress ipAddress, String macAddress) {
        this.m_node = node;
        this.m_macAddress = macAddress;
        this.m_ipAddress = ipAddress;
        this.m_ifIndex = -1;
    }

    public OnmsAtInterface(OnmsNode node, InetAddress ipAddress) {
        this.m_node = node;
        this.m_macAddress = "";
        this.m_ipAddress = ipAddress;
        this.m_ifIndex = -1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("node", (Object)this.m_node).append("ipAddress", (Object)this.m_ipAddress).append("macAddress", (Object)this.m_macAddress).append("status", (Object)this.m_status).append("sourceNodeId", (Object)this.m_sourceNodeId).append("ifIndex", (Object)this.m_ifIndex).append("lastPollTime", (Object)this.m_lastPollTime).toString();
    }

    @Id
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="ipAddr", nullable=false)
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @XmlElement
    @Column(name="atPhysAddr", nullable=false)
    public String getMacAddress() {
        return this.m_macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.m_macAddress = macAddress;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Character getStatus() {
        return this.m_status;
    }

    public void setStatus(Character status) {
        this.m_status = status;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Integer getSourceNodeId() {
        return this.m_sourceNodeId;
    }

    public void setSourceNodeId(Integer sourceNodeId) {
        this.m_sourceNodeId = sourceNodeId;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastPollTime", nullable=false)
    @XmlElement(name="lastPollTime")
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }
}

