/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import java.util.List;
import org.opennms.netmgt.EventConstants;

public class Constants
extends EventConstants {
    public static final char NAME_VAL_DELIM = '=';
    public static final char MULTIPLE_VAL_DELIM = ';';
    public static final String ATTRIB_DELIM = "/\\";
    public static final char DB_ATTRIB_DELIM = ',';
    public static final String VALUE_TRUNCATE_INDICATOR = "...";

    public static String escape(String inStr, char delimchar) {
        StringBuilder buf = new StringBuilder(inStr.length() + 16);
        for (char ch : inStr.toCharArray()) {
            if (ch == delimchar || Character.isISOControl(ch) && !Character.isWhitespace(ch)) {
                buf.append('%');
                buf.append(String.valueOf((int)ch));
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String format(List<String> strings, int maxlen) {
        if (strings == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String s : strings) {
            if (maxlen != 0 && buf.length() >= maxlen) break;
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (maxlen != 0 && buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String[] strings, int maxlen) {
        if (strings == null || strings.length <= 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String s : strings) {
            if (maxlen != 0 && buf.length() >= maxlen) break;
            s = Constants.escape(s, ';');
            if (!first) {
                buf.append(';');
            }
            buf.append(s);
            first = false;
        }
        if (maxlen != 0 && buf.length() >= maxlen) {
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
        }
        return buf.toString();
    }

    public static String format(String origString, int maxlen) {
        if (origString == null) {
            return null;
        }
        String escapedString = Constants.escape(origString, '\u0000');
        if (maxlen != 0 && escapedString.length() >= maxlen) {
            StringBuffer buf = new StringBuffer(escapedString);
            buf.setLength(maxlen - 4);
            buf.append(VALUE_TRUNCATE_INDICATOR);
            return buf.toString();
        }
        return escapedString;
    }
}

