/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.core.utils.IteratorIterator;
import org.opennms.netmgt.model.discovery.IPAddress;
import org.opennms.netmgt.model.discovery.IPAddressRange;

public class IPAddressSet
implements Iterable<IPAddress> {
    private IPAddressRange m_firstRange;
    private IPAddressSet m_remainingRanges;
    public static final IPAddressSet EMPTY = new IPAddressSet();

    public IPAddressSet() {
        this((IPAddressRange)null, (IPAddressSet)null);
    }

    public IPAddressSet(IPAddress addr) {
        this(new IPAddressRange(addr, addr), null);
    }

    public IPAddressSet(IPAddressRange range) {
        this(range, null);
    }

    public IPAddressSet(IPAddressSet set) {
        this(set.m_firstRange, set.m_remainingRanges);
    }

    private IPAddressSet(IPAddressRange firstRange, IPAddressSet remainingRanges) {
        this.m_firstRange = firstRange;
        this.m_remainingRanges = remainingRanges;
    }

    public IPAddressSet(IPAddress begin, IPAddress end) {
        this(end.isLessThan(begin) ? null : new IPAddressRange(begin, end), null);
    }

    public IPAddressSet union(IPAddress addr) {
        return this.union(new IPAddressRange(addr, addr));
    }

    public IPAddressSet union(IPAddressRange range) {
        if (this.isEmpty()) {
            return new IPAddressSet(range);
        }
        if (range.overlaps(this.m_firstRange) || range.adjoins(this.m_firstRange)) {
            IPAddressRange newRange = this.union(range, this.m_firstRange);
            return this.m_remainingRanges == null ? new IPAddressSet(newRange) : this.m_remainingRanges.union(newRange);
        }
        if (range.comesBefore(this.m_firstRange)) {
            return new IPAddressSet(range, this);
        }
        IPAddressSet remaining = this.m_remainingRanges == null ? new IPAddressSet(range) : this.m_remainingRanges.union(range);
        return new IPAddressSet(this.m_firstRange, remaining);
    }

    private IPAddressRange union(IPAddressRange rangeA, IPAddressRange rangeB) {
        IPAddress newBegin = IPAddress.min(rangeA.getBegin(), rangeB.getBegin());
        IPAddress newEnd = IPAddress.max(rangeA.getEnd(), rangeB.getEnd());
        return new IPAddressRange(newBegin, newEnd);
    }

    public IPAddressSet union(IPAddressSet set) {
        if (this.isEmpty()) {
            return set;
        }
        if (this.m_remainingRanges == null) {
            return set.union(this.m_firstRange);
        }
        return this.m_remainingRanges.union(set).union(this.m_firstRange);
    }

    public boolean contains(IPAddress addr) {
        if (this.m_firstRange == null) {
            return false;
        }
        if (this.m_firstRange.contains(addr)) {
            return true;
        }
        if (this.m_remainingRanges == null) {
            return false;
        }
        return this.m_remainingRanges.contains(addr);
    }

    public boolean containsAll(IPAddressSet c) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public boolean isEmpty() {
        return this.m_firstRange == null;
    }

    @Override
    public Iterator<IPAddress> iterator() {
        if (this.isEmpty()) {
            return Collections.EMPTY_SET.iterator();
        }
        if (this.m_remainingRanges == null) {
            return this.m_firstRange.iterator();
        }
        return new IteratorIterator(new Iterator[]{this.m_firstRange.iterator(), this.m_remainingRanges.iterator()});
    }

    public IPAddressSet minus(IPAddress addr) {
        return this.minus(new IPAddressRange(addr, addr));
    }

    public IPAddressSet minus(IPAddressRange range) {
        if (this.isEmpty()) {
            return this;
        }
        if (this.m_remainingRanges == null) {
            return this.minus(this.m_firstRange, range);
        }
        return this.minus(this.m_firstRange, range).union(this.m_remainingRanges.minus(range));
    }

    private IPAddressSet minus(IPAddressRange rangeA, IPAddressRange rangeB) {
        if (!rangeA.overlaps(rangeB)) {
            return this;
        }
        return new IPAddressSet(rangeA.getBegin(), rangeB.getBegin().decr()).union(new IPAddressSet(rangeB.getEnd().incr(), rangeA.getEnd()));
    }

    public IPAddressSet minus(IPAddressSet set) {
        if (set.isEmpty()) {
            return this;
        }
        if (set.m_remainingRanges == null) {
            return this.minus(set.m_firstRange);
        }
        return this.minus(set.m_firstRange).intersect(this.minus(set.m_remainingRanges));
    }

    public IPAddressSet intersect(IPAddressRange range) {
        if (this.isEmpty()) {
            return this;
        }
        IPAddress newBegin = IPAddress.max(this.m_firstRange.getBegin(), range.getBegin());
        IPAddress newEnd = IPAddress.min(this.m_firstRange.getEnd(), range.getEnd());
        if (this.m_remainingRanges == null) {
            return new IPAddressSet(newBegin, newEnd);
        }
        if (newEnd.isLessThan(newBegin)) {
            return this.m_remainingRanges.intersect(range);
        }
        return new IPAddressSet(new IPAddressRange(newBegin, newEnd), this.m_remainingRanges.intersect(range));
    }

    public IPAddressSet intersect(IPAddressSet set) {
        if (set.isEmpty()) {
            return this;
        }
        if (set.m_remainingRanges == null) {
            return this.intersect(set.m_firstRange);
        }
        return this.intersect(set.m_firstRange).union(this.intersect(set.m_remainingRanges));
    }

    public BigInteger size() {
        if (this.m_firstRange == null) {
            return BigInteger.ZERO;
        }
        if (this.m_remainingRanges == null) {
            return this.m_firstRange.size();
        }
        return this.m_firstRange.size().add(this.m_remainingRanges.size());
    }

    public int getRangeCount() {
        if (this.m_firstRange == null) {
            return 0;
        }
        if (this.m_remainingRanges == null) {
            return 1;
        }
        return this.m_remainingRanges.getRangeCount() + 1;
    }

    public IPAddressRange[] getRanges() {
        LinkedList<IPAddressRange> accumulator = new LinkedList<IPAddressRange>();
        this.computeRanges(accumulator);
        return accumulator.toArray(new IPAddressRange[accumulator.size()]);
    }

    private void computeRanges(List<IPAddressRange> accumulator) {
        if (this.m_firstRange != null) {
            accumulator.add(this.m_firstRange);
        }
        if (this.m_remainingRanges != null) {
            this.computeRanges(accumulator);
        }
    }

    public String toString() {
        return "{" + this.toStringHelper(new StringBuilder(), false) + "}";
    }

    private StringBuilder toStringHelper(StringBuilder buf, boolean leadingComma) {
        if (this.m_firstRange != null) {
            if (leadingComma) {
                buf.append(", ");
            }
            buf.append(this.m_firstRange);
        }
        if (this.m_remainingRanges != null) {
            this.m_remainingRanges.toStringHelper(buf, true);
        }
        return buf;
    }
}

