/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;

public class IPAddress
implements Comparable<IPAddress> {
    private static final byte MAX_BYTE = -1;
    private static final BigInteger MIN_INET_ADDRESS_BIG_INTEGER = new BigInteger("0");
    private static final BigInteger MAX_INET_ADDRESS_BIG_INTEGER;
    final byte[] m_ipAddr;

    public IPAddress(IPAddress addr) {
        this.m_ipAddr = addr.m_ipAddr;
    }

    public IPAddress(String dottedNotation) {
        this.m_ipAddr = InetAddressUtils.toIpAddrBytes((String)dottedNotation);
    }

    public IPAddress(InetAddress inetAddress) {
        this.m_ipAddr = inetAddress.getAddress();
    }

    public IPAddress(byte[] ipAddrOctets) {
        this.m_ipAddr = ipAddrOctets;
    }

    public InetAddress toInetAddress() {
        return InetAddressUtils.getInetAddress((byte[])this.m_ipAddr);
    }

    public byte[] toOctets() {
        return this.m_ipAddr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPAddress) {
            return new ByteArrayComparator().compare(this.m_ipAddr, ((IPAddress)obj).toOctets()) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(IPAddress o) {
        return new ByteArrayComparator().compare(this.m_ipAddr, o.toOctets());
    }

    public String toString() {
        return InetAddressUtils.toIpAddrString((byte[])this.m_ipAddr);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.m_ipAddr);
    }

    public IPAddress incr() {
        BigInteger addr = new BigInteger(1, this.m_ipAddr);
        if ((addr = addr.add(new BigInteger("1"))).compareTo(MAX_INET_ADDRESS_BIG_INTEGER) > 0) {
            throw new IllegalStateException("Cannot increment IP address above 2^128 - 1 (the maximum IPv6 address): " + this.toString());
        }
        try {
            return new IPAddress(InetAddressUtils.convertBigIntegerIntoInetAddress((BigInteger)addr).getAddress());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public IPAddress decr() {
        BigInteger addr = new BigInteger(1, this.m_ipAddr);
        if ((addr = addr.subtract(new BigInteger("1"))).compareTo(MIN_INET_ADDRESS_BIG_INTEGER) < 0) {
            throw new IllegalStateException("Cannot decrement IP address below zero: " + this.toString());
        }
        try {
            return new IPAddress(InetAddressUtils.convertBigIntegerIntoInetAddress((BigInteger)addr).getAddress());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public boolean isPredecessorOf(IPAddress other) {
        return other.decr().equals(this);
    }

    public boolean isSuccessorOf(IPAddress other) {
        return other.incr().equals(this);
    }

    public boolean isLessThan(IPAddress other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(IPAddress other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(IPAddress other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(IPAddress other) {
        return this.compareTo(other) >= 0;
    }

    public static IPAddress min(IPAddress a, IPAddress b) {
        return a.isLessThan(b) ? a : b;
    }

    public static IPAddress max(IPAddress a, IPAddress b) {
        return a.isGreaterThan(b) ? a : b;
    }

    static {
        byte[] maxBytes = new byte[16];
        Arrays.fill(maxBytes, (byte)-1);
        MAX_INET_ADDRESS_BIG_INTEGER = new BigInteger(1, maxBytes);
    }
}

