/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.opennms.netmgt.model.StatisticsReportData;

@Entity
@Table(name="statisticsReport")
public class StatisticsReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer m_id;
    private Date m_startDate;
    private Date m_endDate;
    private String m_name;
    private String m_description;
    private Date m_jobStartedDate;
    private Date m_jobCompletedDate;
    private Date m_purgeDate;
    private Set<StatisticsReportData> m_data = new HashSet<StatisticsReportData>();

    @Id
    @Column(name="id")
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="startDate", nullable=false)
    public Date getStartDate() {
        return this.m_startDate;
    }

    public void setStartDate(Date startDate) {
        this.m_startDate = startDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="endDate", nullable=false)
    public Date getEndDate() {
        return this.m_endDate;
    }

    public void setEndDate(Date endDate) {
        this.m_endDate = endDate;
    }

    @Column(name="name", length=63, nullable=false)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Column(name="description", length=255, nullable=false)
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="jobStartedDate", nullable=false)
    public Date getJobStartedDate() {
        return this.m_jobStartedDate;
    }

    public void setJobStartedDate(Date jobStartedDate) {
        this.m_jobStartedDate = jobStartedDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="jobCompletedDate", nullable=false)
    public Date getJobCompletedDate() {
        return this.m_jobCompletedDate;
    }

    public void setJobCompletedDate(Date jobCompletedDate) {
        this.m_jobCompletedDate = jobCompletedDate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="purgeDate", nullable=false)
    public Date getPurgeDate() {
        return this.m_purgeDate;
    }

    public void setPurgeDate(Date purgeDate) {
        this.m_purgeDate = purgeDate;
    }

    @OneToMany(mappedBy="report", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<StatisticsReportData> getData() {
        return this.m_data;
    }

    public void setData(Set<StatisticsReportData> data) {
        this.m_data = data;
    }

    public void addData(StatisticsReportData datum) {
        this.m_data.add(datum);
    }

    @Transient
    public long getDuration() {
        return this.m_endDate.getTime() - this.m_startDate.getTime();
    }

    @Transient
    public String getDurationString() {
        return this.getStringForInterval(this.getDuration());
    }

    @Transient
    public long getJobDuration() {
        return this.m_jobCompletedDate.getTime() - this.m_jobStartedDate.getTime();
    }

    @Transient
    public String getJobDurationString() {
        return this.getStringForInterval(this.getJobDuration());
    }

    @Transient
    public Double getMaxDatumValue() {
        Double mv = null;
        Iterator<StatisticsReportData> it = this.m_data.iterator();
        while (it.hasNext()) {
            Double val = it.next().getValue();
            if (mv == null) {
                mv = val;
                continue;
            }
            if (!(val > mv)) continue;
            mv = val;
        }
        return mv;
    }

    @Transient
    public Double getMinDatumValue() {
        Double mv = null;
        Iterator<StatisticsReportData> it = this.m_data.iterator();
        while (it.hasNext()) {
            Double val = it.next().getValue();
            if (mv == null) {
                mv = val;
                continue;
            }
            if (!(val < mv)) continue;
            mv = val;
        }
        return mv;
    }

    private String getStringForInterval(long interval) {
        double value = interval;
        value /= 1000.0;
        String unit = "seconds";
        if (value < 60.0) {
            return value + " " + unit;
        }
        value /= 60.0;
        unit = "minutes";
        if (value < 60.0) {
            return value + " " + unit;
        }
        value /= 60.0;
        unit = "hours";
        if (value < 24.0) {
            return value + " " + unit;
        }
        unit = "days";
        return (value /= 24.0) + " " + unit;
    }
}

