/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.RrdLabelUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="snmpInterface")
@Entity
@Table(name="snmpInterface")
public class OnmsSnmpInterface
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = -5396189389666285305L;
    private Integer m_id;
    private String m_netMask;
    private String m_physAddr;
    private Integer m_ifIndex;
    private String m_ifDescr;
    private Integer m_ifType;
    private String m_ifName;
    private Long m_ifSpeed;
    private Integer m_ifAdminStatus;
    private Integer m_ifOperStatus;
    private String m_ifAlias;
    private Date m_lastCapsdPoll;
    private String m_collect = "N";
    private String m_poll = "N";
    private Date m_lastSnmpPoll;
    private OnmsNode m_node;
    private Set<OnmsIpInterface> m_ipInterfaces = new HashSet<OnmsIpInterface>();

    public OnmsSnmpInterface(OnmsNode node, int ifIndex) {
        this(node, new Integer(ifIndex));
    }

    public OnmsSnmpInterface(OnmsNode node, Integer ifIndex) {
        this.m_ifIndex = ifIndex;
        this.m_node = node;
        if (node != null) {
            node.getSnmpInterfaces().add(this);
        }
    }

    public OnmsSnmpInterface() {
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    @XmlAttribute(name="id")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="snmpIpAdEntNetMask")
    public String getNetMask() {
        return this.m_netMask;
    }

    public void setNetMask(String snmpipadentnetmask) {
        this.m_netMask = snmpipadentnetmask;
    }

    @Column(name="snmpPhysAddr", length=32)
    public String getPhysAddr() {
        return this.m_physAddr;
    }

    public void setPhysAddr(String snmpphysaddr) {
        this.m_physAddr = snmpphysaddr;
    }

    @Column(name="snmpIfIndex")
    @XmlAttribute(name="ifIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer snmpifindex) {
        this.m_ifIndex = snmpifindex;
    }

    @Column(name="snmpIfDescr", length=256)
    public String getIfDescr() {
        return this.m_ifDescr;
    }

    public void setIfDescr(String snmpifdescr) {
        this.m_ifDescr = snmpifdescr;
    }

    @Column(name="snmpIfType")
    public Integer getIfType() {
        return this.m_ifType;
    }

    public void setIfType(Integer snmpiftype) {
        this.m_ifType = snmpiftype;
    }

    @Column(name="snmpIfName", length=32)
    public String getIfName() {
        return this.m_ifName;
    }

    public void setIfName(String snmpifname) {
        this.m_ifName = snmpifname;
    }

    @Column(name="snmpIfSpeed")
    public Long getIfSpeed() {
        return this.m_ifSpeed;
    }

    public void setIfSpeed(Long snmpifspeed) {
        this.m_ifSpeed = snmpifspeed;
    }

    @Column(name="snmpIfAdminStatus")
    public Integer getIfAdminStatus() {
        return this.m_ifAdminStatus;
    }

    public void setIfAdminStatus(Integer snmpifadminstatus) {
        this.m_ifAdminStatus = snmpifadminstatus;
    }

    @Column(name="snmpIfOperStatus")
    public Integer getIfOperStatus() {
        return this.m_ifOperStatus;
    }

    public void setIfOperStatus(Integer snmpifoperstatus) {
        this.m_ifOperStatus = snmpifoperstatus;
    }

    @Column(name="snmpIfAlias", length=256)
    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public void setIfAlias(String snmpifalias) {
        this.m_ifAlias = snmpifalias;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="snmpLastCapsdPoll")
    public Date getLastCapsdPoll() {
        return this.m_lastCapsdPoll;
    }

    public void setLastCapsdPoll(Date lastCapsdPoll) {
        this.m_lastCapsdPoll = lastCapsdPoll;
    }

    @Column(name="snmpCollect")
    @XmlAttribute(name="collectFlag")
    public String getCollect() {
        return this.m_collect;
    }

    public void setCollect(String collect) {
        this.m_collect = collect;
    }

    @Column(name="snmpPoll")
    @XmlAttribute(name="pollFlag")
    public String getPoll() {
        return this.m_poll;
    }

    public void setPoll(String poll) {
        this.m_poll = poll;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="snmpLastSnmpPoll")
    public Date getLastSnmpPoll() {
        return this.m_lastSnmpPoll;
    }

    public void setLastSnmpPoll(Date lastSnmpPoll) {
        this.m_lastSnmpPoll = lastSnmpPoll;
    }

    @Transient
    public boolean isCollectionUserSpecified() {
        return this.m_collect.startsWith("U");
    }

    @Transient
    @XmlAttribute(name="collect")
    public boolean isCollectionEnabled() {
        return "C".equals(this.m_collect) || "UC".equals(this.m_collect);
    }

    public void setCollectionEnabled(boolean shouldCollect) {
        this.setCollectionEnabled(shouldCollect, false);
    }

    public void setCollectionEnabled(boolean shouldCollect, boolean userSpecified) {
        if (userSpecified) {
            this.m_collect = shouldCollect ? "UC" : "UN";
        } else if (!this.m_collect.startsWith("U")) {
            this.m_collect = shouldCollect ? "C" : "N";
        }
    }

    @Transient
    @XmlAttribute(name="poll")
    public boolean isPollEnabled() {
        return "P".equals(this.m_poll);
    }

    @XmlIDREF
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("snmpipadentnetmask", (Object)this.getNetMask()).append("snmpphysaddr", (Object)this.getPhysAddr()).append("snmpifindex", (Object)this.getIfIndex()).append("snmpifdescr", (Object)this.getIfDescr()).append("snmpiftype", (Object)this.getIfType()).append("snmpifname", (Object)this.getIfName()).append("snmpifspeed", (Object)this.getIfSpeed()).append("snmpifadminstatus", (Object)this.getIfAdminStatus()).append("snmpifoperstatus", (Object)this.getIfOperStatus()).append("snmpifalias", (Object)this.getIfAlias()).append("snmpCollect", (Object)this.getCollect()).append("lastCapsdPoll", (Object)this.getLastCapsdPoll()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitSnmpInterface(this);
        visitor.visitSnmpInterfaceComplete(this);
    }

    @XmlIDREF
    @OneToMany(mappedBy="snmpInterface", fetch=FetchType.LAZY)
    public Set<OnmsIpInterface> getIpInterfaces() {
        return this.m_ipInterfaces;
    }

    public void setIpInterfaces(Set<OnmsIpInterface> ipInterfaces) {
        this.m_ipInterfaces = ipInterfaces;
    }

    @Transient
    @XmlTransient
    public OnmsIpInterface getPrimaryIpInterface() {
        return this.getNode().getPrimaryInterface();
    }

    public ThreadCategory log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String computePhysAddrForRRD() {
        String physAddrForRRD = null;
        if (this.getPhysAddr() != null) {
            String parsedPhysAddr = AlphaNumeric.parseAndTrim((String)this.getPhysAddr());
            if (parsedPhysAddr.length() == 12) {
                physAddrForRRD = parsedPhysAddr;
            } else if (this.log().isDebugEnabled()) {
                this.log().debug("physAddrForRRD: physical address len is NOT 12, physAddr=" + parsedPhysAddr);
            }
        }
        this.log().debug("computed physAddr for " + this + " to be " + physAddrForRRD);
        return physAddrForRRD;
    }

    public String computeNameForRRD() {
        String label = null;
        if (this.getIfName() != null) {
            label = AlphaNumeric.parseAndReplace((String)this.getIfName(), (char)'_');
        } else if (this.getIfDescr() != null) {
            label = AlphaNumeric.parseAndReplace((String)this.getIfDescr(), (char)'_');
        } else {
            this.log().info("Interface (" + this + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'.");
            label = "no_ifLabel";
        }
        return label;
    }

    public String computeLabelForRRD() {
        return RrdLabelUtils.computeLabelForRRD((String)this.getIfName(), (String)this.getIfDescr(), (String)this.getPhysAddr());
    }

    public void addIpInterface(OnmsIpInterface iface) {
        this.m_ipInterfaces.add(iface);
    }

    public void mergeSnmpInterfaceAttributes(OnmsSnmpInterface scannedSnmpIface) {
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfAdminStatus(), this.getIfAdminStatus())) {
            this.setIfAdminStatus(scannedSnmpIface.getIfAdminStatus());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfAlias(), this.getIfAlias())) {
            this.setIfAlias(scannedSnmpIface.getIfAlias());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfDescr(), this.getIfDescr())) {
            this.setIfDescr(scannedSnmpIface.getIfDescr());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfName(), this.getIfName())) {
            this.setIfName(scannedSnmpIface.getIfName());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfOperStatus(), this.getIfOperStatus())) {
            this.setIfOperStatus(scannedSnmpIface.getIfOperStatus());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfSpeed(), this.getIfSpeed())) {
            this.setIfSpeed(scannedSnmpIface.getIfSpeed());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getIfType(), this.getIfType())) {
            this.setIfType(scannedSnmpIface.getIfType());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getNetMask(), this.getNetMask())) {
            this.setNetMask(scannedSnmpIface.getNetMask());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getPhysAddr(), this.getPhysAddr())) {
            this.setPhysAddr(scannedSnmpIface.getPhysAddr());
        }
        if (OnmsSnmpInterface.hasNewValue(scannedSnmpIface.getLastCapsdPoll(), this.getLastCapsdPoll())) {
            this.setLastCapsdPoll(scannedSnmpIface.getLastCapsdPoll());
        }
        if (scannedSnmpIface.isCollectionUserSpecified() || !this.isCollectionUserSpecified()) {
            this.setCollectionEnabled(scannedSnmpIface.isCollectionEnabled(), scannedSnmpIface.isCollectionUserSpecified());
        }
    }
}

