/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.annotations.Filter;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="outage")
@Entity
@Table(name="outages")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class OnmsOutage
implements Serializable {
    private static final long serialVersionUID = 3846398168228820151L;
    private Integer m_id;
    private Date m_ifLostService;
    private Date m_ifRegainedService;
    private OnmsEvent m_serviceRegainedEvent;
    private OnmsEvent m_serviceLostEvent;
    private OnmsMonitoredService m_monitoredService;
    private Date m_suppressTime;
    private String m_suppressedBy;

    public OnmsOutage(Date ifLostService, Date ifRegainedService, OnmsEvent eventBySvcRegainedEvent, OnmsEvent eventBySvcLostEvent, OnmsMonitoredService monitoredService, Date suppressTime, String suppressedBy) {
        this.m_ifLostService = ifLostService;
        this.m_ifRegainedService = ifRegainedService;
        this.m_serviceRegainedEvent = eventBySvcRegainedEvent;
        this.m_serviceLostEvent = eventBySvcLostEvent;
        this.m_monitoredService = monitoredService;
        this.m_suppressTime = suppressTime;
        this.m_suppressedBy = suppressedBy;
    }

    public OnmsOutage() {
    }

    public OnmsOutage(Date ifLostService, OnmsEvent eventBySvcLostEvent, OnmsMonitoredService monitoredService) {
        this.m_ifLostService = ifLostService;
        this.m_serviceLostEvent = eventBySvcLostEvent;
        this.m_monitoredService = monitoredService;
    }

    @Id
    @XmlAttribute(name="id")
    @Column(name="outageId")
    @SequenceGenerator(name="outageSequence", sequenceName="outageNxtId")
    @GeneratedValue(generator="outageSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer outageId) {
        this.m_id = outageId;
    }

    @ManyToOne
    @JoinColumn(name="ifserviceId")
    public OnmsMonitoredService getMonitoredService() {
        return this.m_monitoredService;
    }

    public void setMonitoredService(OnmsMonitoredService monitoredService) {
        this.m_monitoredService = monitoredService;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ifLostService", nullable=false)
    public Date getIfLostService() {
        return this.m_ifLostService;
    }

    public void setIfLostService(Date ifLostService) {
        this.m_ifLostService = ifLostService;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="svcLostEventId")
    public OnmsEvent getServiceLostEvent() {
        return this.m_serviceLostEvent;
    }

    public void setServiceLostEvent(OnmsEvent svcLostEvent) {
        this.m_serviceLostEvent = svcLostEvent;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ifRegainedService")
    public Date getIfRegainedService() {
        return this.m_ifRegainedService;
    }

    public void setIfRegainedService(Date ifRegainedService) {
        this.m_ifRegainedService = ifRegainedService;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="svcRegainedEventId")
    public OnmsEvent getServiceRegainedEvent() {
        return this.m_serviceRegainedEvent;
    }

    public void setServiceRegainedEvent(OnmsEvent svcRegainedEvent) {
        this.m_serviceRegainedEvent = svcRegainedEvent;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="suppressTime")
    public Date getSuppressTime() {
        return this.m_suppressTime;
    }

    public void setSuppressTime(Date timeToSuppress) {
        this.m_suppressTime = timeToSuppress;
    }

    @Column(name="suppressedBy")
    public String getSuppressedBy() {
        return this.m_suppressedBy;
    }

    public void setSuppressedBy(String suppressorMan) {
        this.m_suppressedBy = suppressorMan;
    }

    @Transient
    public Integer getNodeId() {
        return this.getMonitoredService().getNodeId();
    }

    @Transient
    @XmlElement(name="ipAddress")
    public InetAddress getIpAddress() {
        return this.getMonitoredService().getIpAddress();
    }

    @Transient
    @XmlElement(name="ipAddress")
    public String getIpAddressAsString() {
        return this.getMonitoredService().getIpAddressAsString();
    }

    @Transient
    public Integer getServiceId() {
        return this.getMonitoredService().getServiceId();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("outageId", (Object)this.getId()).append("ifLostService", (Object)this.getIfLostService()).append("ifRegainedService", (Object)this.getIfRegainedService()).append("suppressedBy", (Object)this.getSuppressedBy()).append("suppressTime", (Object)this.getSuppressTime()).append("ipAddr", (Object)this.getIpAddressAsString()).append("serviceid", (Object)this.getServiceId()).append("nodeid", (Object)this.getNodeId()).toString();
    }
}

