/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.Type;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="alarm")
@Entity
@Table(name="alarms")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class OnmsAlarm
implements Acknowledgeable,
Serializable {
    private static final long serialVersionUID = 7275548439687562161L;
    public static final int PROBLEM_TYPE = 1;
    public static final int RESOLUTION_TYPE = 2;
    private Integer m_id;
    private String m_uei;
    private OnmsDistPoller m_distPoller;
    private OnmsNode m_node;
    private InetAddress m_ipAddr;
    private OnmsServiceType m_serviceType;
    private String m_reductionKey;
    private Integer m_alarmType;
    private Integer m_ifIndex;
    private Integer m_counter;
    private OnmsSeverity m_severity;
    private Date m_firstEventTime;
    private Date m_lastEventTime;
    private Date m_firstAutomationTime;
    private Date m_lastAutomationTime;
    private String m_description;
    private String m_logMsg;
    private String m_operInstruct;
    private String m_tTicketId;
    private TroubleTicketState m_tTicketState;
    private String m_mouseOverText;
    private Date m_suppressedUntil;
    private String m_suppressedUser;
    private Date m_suppressedTime;
    private String m_alarmAckUser;
    private Date m_alarmAckTime;
    private String m_clearKey;
    private OnmsEvent m_lastEvent;
    private String m_eventParms;
    private String m_managedObjectInstance;
    private String m_managedObjectType;
    private String m_applicationDN;
    private String m_ossPrimaryKey;
    private String m_x733AlarmType;
    private String m_qosAlarmState;
    private int m_x733ProbableCause = 0;
    private Map<String, String> m_details;

    public OnmsAlarm() {
    }

    public OnmsAlarm(Integer alarmid, String eventuei, OnmsDistPoller distPoller, Integer counter, Integer severity, Date firsteventtime, OnmsEvent event) {
        this.m_id = alarmid;
        this.m_uei = eventuei;
        this.m_distPoller = distPoller;
        this.m_counter = counter;
        this.m_severity = OnmsSeverity.get(severity);
        this.m_firstEventTime = firsteventtime;
        this.m_lastEvent = event;
    }

    @Id
    @SequenceGenerator(name="alarmSequence", sequenceName="alarmsNxtId")
    @GeneratedValue(generator="alarmSequence")
    @Column(name="alarmId")
    @XmlAttribute(name="id")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer alarmid) {
        this.m_id = alarmid;
    }

    @Column(name="eventUEI", length=256, nullable=false)
    @XmlElement(name="uei")
    public String getUei() {
        return this.m_uei;
    }

    public void setUei(String eventuei) {
        this.m_uei = eventuei;
    }

    @XmlTransient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dpName", nullable=false)
    public OnmsDistPoller getDistPoller() {
        return this.m_distPoller;
    }

    public void setDistPoller(OnmsDistPoller distPoller) {
        this.m_distPoller = distPoller;
    }

    @Override
    @XmlTransient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="ipAddr")
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddr() {
        return this.m_ipAddr;
    }

    public void setIpAddr(InetAddress ipaddr) {
        this.m_ipAddr = ipaddr;
    }

    @XmlTransient
    @ManyToOne
    @JoinColumn(name="serviceid")
    public OnmsServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(OnmsServiceType service) {
        this.m_serviceType = service;
    }

    @Column(name="reductionKey", unique=true, length=256)
    @XmlElement(name="reductionKey")
    public String getReductionKey() {
        return this.m_reductionKey;
    }

    public void setReductionKey(String reductionkey) {
        this.m_reductionKey = reductionkey;
    }

    @Column(name="alarmType")
    @XmlAttribute(name="type")
    public Integer getAlarmType() {
        return this.m_alarmType;
    }

    public void setAlarmType(Integer alarmtype) {
        this.m_alarmType = alarmtype;
    }

    @XmlAttribute(name="count")
    @Column(name="counter", nullable=false)
    public Integer getCounter() {
        return this.m_counter;
    }

    public void setCounter(Integer counter) {
        this.m_counter = counter;
    }

    @Transient
    @XmlAttribute(name="severity")
    public String getSeverityLabel() {
        return this.m_severity.name();
    }

    public void setSeverityLabel(String label) {
        this.m_severity = OnmsSeverity.get(label);
    }

    @Transient
    @XmlTransient
    public OnmsSeverity getSeverity() {
        return this.m_severity;
    }

    @Transient
    public void setSeverity(OnmsSeverity severity) {
        this.m_severity = severity;
    }

    @Column(name="severity", nullable=false)
    @XmlTransient
    public Integer getSeverityId() {
        return this.m_severity.getId();
    }

    public void setSeverityId(Integer severity) {
        this.m_severity = OnmsSeverity.get(severity);
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="firstEventTime")
    public Date getFirstEventTime() {
        return this.m_firstEventTime;
    }

    public void setFirstEventTime(Date firsteventtime) {
        this.m_firstEventTime = firsteventtime;
    }

    @Column(name="description", length=4000)
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Column(name="logmsg", length=1024)
    @XmlElement(name="logMessage")
    public String getLogMsg() {
        return this.m_logMsg;
    }

    public void setLogMsg(String logmsg) {
        this.m_logMsg = logmsg;
    }

    @XmlElement(name="operatorInstructions")
    @Column(name="operinstruct", length=1024)
    public String getOperInstruct() {
        return this.m_operInstruct;
    }

    public void setOperInstruct(String operinstruct) {
        this.m_operInstruct = operinstruct;
    }

    @XmlElement(name="troubleTicket")
    @Column(name="tticketId", length=128)
    public String getTTicketId() {
        return this.m_tTicketId;
    }

    public void setTTicketId(String tticketid) {
        this.m_tTicketId = tticketid;
    }

    @XmlElement(name="troubleTicketState")
    @Column(name="tticketState")
    public TroubleTicketState getTTicketState() {
        return this.m_tTicketState;
    }

    public void setTTicketState(TroubleTicketState tticketstate) {
        this.m_tTicketState = tticketstate;
    }

    @XmlElement(name="mouseOverText")
    @Column(name="mouseOverText", length=64)
    public String getMouseOverText() {
        return this.m_mouseOverText;
    }

    public void setMouseOverText(String mouseovertext) {
        this.m_mouseOverText = mouseovertext;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @XmlElement(name="suppressedUntil")
    @Column(name="suppressedUntil")
    public Date getSuppressedUntil() {
        return this.m_suppressedUntil;
    }

    public void setSuppressedUntil(Date suppresseduntil) {
        this.m_suppressedUntil = suppresseduntil;
    }

    @XmlElement(name="suppressedBy")
    @Column(name="suppressedUser", length=256)
    public String getSuppressedUser() {
        return this.m_suppressedUser;
    }

    public void setSuppressedUser(String suppresseduser) {
        this.m_suppressedUser = suppresseduser;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="suppressedTime")
    @XmlElement(name="suppressedTime")
    public Date getSuppressedTime() {
        return this.m_suppressedTime;
    }

    public void setSuppressedTime(Date suppressedtime) {
        this.m_suppressedTime = suppressedtime;
    }

    @Column(name="alarmAckUser", length=256)
    @XmlElement(name="ackUser")
    public String getAlarmAckUser() {
        return this.m_alarmAckUser;
    }

    public void setAlarmAckUser(String alarmackuser) {
        this.m_alarmAckUser = alarmackuser;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="alarmAckTime")
    @XmlElement(name="ackTime")
    public Date getAlarmAckTime() {
        return this.m_alarmAckTime;
    }

    public void setAlarmAckTime(Date alarmacktime) {
        this.m_alarmAckTime = alarmacktime;
    }

    @XmlElement(name="clearKey")
    @Column(name="clearKey", length=256)
    public String getClearKey() {
        return this.m_clearKey;
    }

    public void setClearKey(String clearKey) {
        this.m_clearKey = clearKey;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumn(name="lastEventId")
    @XmlElement(name="lastEvent")
    public OnmsEvent getLastEvent() {
        return this.m_lastEvent;
    }

    public void setLastEvent(OnmsEvent event) {
        this.m_lastEvent = event;
        if (event != null) {
            this.m_lastEventTime = event.getEventTime();
        }
    }

    @XmlElement(name="parms")
    @Column(name="eventParms", length=1024)
    public String getEventParms() {
        return this.m_eventParms;
    }

    public void setEventParms(String eventparms) {
        this.m_eventParms = eventparms;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("alarmid", (Object)this.getId()).toString();
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastEventTime")
    @XmlElement(name="lastEventTime")
    public Date getLastEventTime() {
        return this.m_lastEventTime;
    }

    public void setLastEventTime(Date lastEventTime) {
        this.m_lastEventTime = lastEventTime;
    }

    @XmlElement(name="applicationDN")
    @Column(name="applicationDN", length=512)
    public String getApplicationDN() {
        return this.m_applicationDN;
    }

    public void setApplicationDN(String applicationDN) {
        this.m_applicationDN = applicationDN;
    }

    @Column(name="managedObjectInstance", length=512)
    public String getManagedObjectInstance() {
        return this.m_managedObjectInstance;
    }

    public void setManagedObjectInstance(String managedObjectInstance) {
        this.m_managedObjectInstance = managedObjectInstance;
    }

    @Column(name="managedObjectType", length=512)
    public String getManagedObjectType() {
        return this.m_managedObjectType;
    }

    public void setManagedObjectType(String managedObjectType) {
        this.m_managedObjectType = managedObjectType;
    }

    @Column(name="ossPrimaryKey", length=512)
    public String getOssPrimaryKey() {
        return this.m_ossPrimaryKey;
    }

    public void setOssPrimaryKey(String key) {
        this.m_ossPrimaryKey = key;
    }

    @Column(name="x733AlarmType", length=31)
    public String getX733AlarmType() {
        return this.m_x733AlarmType;
    }

    public void setX733AlarmType(String alarmType) {
        this.m_x733AlarmType = alarmType;
    }

    @Column(name="x733ProbableCause", nullable=false)
    public int getX733ProbableCause() {
        return this.m_x733ProbableCause;
    }

    public void setX733ProbableCause(int cause) {
        this.m_x733ProbableCause = cause;
    }

    @Column(name="qosAlarmState", length=31)
    public String getQosAlarmState() {
        return this.m_qosAlarmState;
    }

    public void setQosAlarmState(String alarmState) {
        this.m_qosAlarmState = alarmState;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="firstAutomationTime")
    @XmlElement(name="firstAutomationTime")
    public Date getFirstAutomationTime() {
        return this.m_firstAutomationTime;
    }

    public void setFirstAutomationTime(Date firstAutomationTime) {
        this.m_firstAutomationTime = firstAutomationTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastAutomationTime")
    @XmlElement(name="lastAutomationTime")
    public Date getLastAutomationTime() {
        return this.m_lastAutomationTime;
    }

    public void setLastAutomationTime(Date lastAutomationTime) {
        this.m_lastAutomationTime = lastAutomationTime;
    }

    @XmlTransient
    @CollectionOfElements
    @JoinTable(name="alarm_details", joinColumns={@JoinColumn(name="alarmId")})
    @MapKey(columns={@Column(name="attribute")})
    @Column(name="attributeValue", nullable=false)
    public Map<String, String> getDetails() {
        return this.m_details;
    }

    public void setDetails(Map<String, String> alarmDetails) {
        this.m_details = alarmDetails;
    }

    @Column(name="ifIndex")
    @XmlAttribute(name="ifIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @Override
    public void acknowledge(String user) {
        if (this.m_alarmAckTime == null || this.m_alarmAckUser == null) {
            this.m_alarmAckTime = Calendar.getInstance().getTime();
            this.m_alarmAckUser = user;
        }
    }

    @Override
    public void unacknowledge(String ackUser) {
        this.m_alarmAckTime = null;
        this.m_alarmAckUser = null;
    }

    @Override
    public void clear(String ackUser) {
        this.m_severity = OnmsSeverity.CLEARED;
    }

    @Override
    public void escalate(String ackUser) {
        this.m_severity = OnmsSeverity.escalate(this.m_severity);
    }

    @Override
    @Transient
    public AckType getType() {
        return AckType.ALARM;
    }

    @Override
    @Transient
    public Integer getAckId() {
        return this.m_id;
    }

    @Override
    @Transient
    public String getAckUser() {
        return this.m_alarmAckUser;
    }

    @Override
    @Transient
    public Date getAckTime() {
        return this.m_alarmAckTime;
    }
}

