//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2006 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Modifications:
//
// 2007 Jul 23: Minor whitespace changes. - dj@opennms.org
//
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
// OpenNMS Licensing       <license@opennms.org>
//     http://www.opennms.org/
//     http://www.opennms.com/
//

package org.opennms.netmgt.model;

import java.util.List;

/**
 * <p>ServiceSelector class.</p>
 *
 * @author <a href="mailto:brozow@opennms.org">Mathew Brozowski</a>
 * @author <a href="mailto:jason.aras@fastsearch.com">Jason Ayers</a>
 */
public class ServiceSelector {
	private String m_filterRule;
	private List<String> m_serviceNames;
	
	
	/**
	 * <p>Constructor for ServiceSelector.</p>
	 *
	 * @param filterRule a {@link java.lang.String} object.
	 * @param serviceNames a {@link java.util.List} object.
	 */
	public ServiceSelector(String filterRule, List<String> serviceNames) {
		m_filterRule = filterRule;
		m_serviceNames = serviceNames;
	}
	
	/**
	 * <p>getFilterRule</p>
	 *
	 * @return a {@link java.lang.String} object.
	 */
	public String getFilterRule() {
		return m_filterRule;
	}
	
	/**
	 * <p>getServiceNames</p>
	 *
	 * @return a {@link java.util.List} object.
	 */
	public List<String> getServiceNames() {
		return m_serviceNames;
	}
}
