/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IPAddrRange
implements Iterable<InetAddress> {
    private final byte[] m_begin;
    private final byte[] m_end;

    IPAddrRange(String fromIP, String toIP) throws UnknownHostException {
        this(InetAddress.getByName(fromIP), InetAddress.getByName(toIP));
    }

    IPAddrRange(InetAddress start, InetAddress end) {
        byte[] from = start.getAddress();
        byte[] to = end.getAddress();
        if (new ByteArrayComparator().compare(from, to) > 0) {
            ThreadCategory.getInstance(this.getClass()).warn("The beginning of the address range is greater than the end of the address range (" + start.getHostAddress() + " - " + end.getHostAddress() + "), swapping values to create a valid IP address range");
            this.m_end = from;
            this.m_begin = to;
        } else {
            this.m_begin = from;
            this.m_end = to;
        }
    }

    boolean contains(InetAddress ipAddr) {
        return InetAddressUtils.isInetAddressInRange((byte[])ipAddr.getAddress(), (byte[])this.m_begin, (byte[])this.m_end);
    }

    boolean contains(String ipAddr) throws UnknownHostException {
        return this.contains(InetAddress.getByName(ipAddr));
    }

    @Override
    public Iterator<InetAddress> iterator() {
        return new IPAddressRangeGenerator(this.m_begin, this.m_end);
    }

    Enumeration<InetAddress> elements() {
        return new IPAddressRangeGenerator(this.m_begin, this.m_end);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IPAddressRangeGenerator
    implements Enumeration<InetAddress>,
    Iterator<InetAddress> {
        private BigInteger m_next;
        private final BigInteger m_end;

        static InetAddress make(BigInteger addr) {
            InetAddress naddr = null;
            try {
                naddr = InetAddressUtils.convertBigIntegerIntoInetAddress((BigInteger)addr);
            }
            catch (UnknownHostException uhE) {
                naddr = null;
            }
            return naddr;
        }

        IPAddressRangeGenerator(byte[] start, byte[] end) {
            if (new ByteArrayComparator().compare(start, end) > 0) {
                throw new IllegalArgumentException("start must be less than or equal to end");
            }
            this.m_next = new BigInteger(1, start);
            this.m_end = new BigInteger(1, end);
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_next.compareTo(this.m_end) <= 0;
        }

        @Override
        public InetAddress nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("End of Range");
            }
            this.m_next = this.m_next.add(new BigInteger("1"));
            InetAddress element = IPAddressRangeGenerator.make(this.m_next);
            return element;
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public InetAddress next() {
            return this.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove operation is not supported by the iterator");
        }
    }
}

