/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsVulnPlugin;
import org.springframework.core.style.ToStringCreator;

@Entity
@Table(name="vulnerabilities")
public class OnmsVulnerability
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = -2212905105927237801L;
    private Integer m_vulnerabilityId;
    private OnmsNode m_node;
    private OnmsMonitoredService m_monitoredService;
    private Date m_creationTime;
    private Date m_lastAttemptTime;
    private Date m_lastScanTime;
    private Date m_resolvedTime;
    private Integer m_severity;
    private OnmsVulnPlugin m_vulnPlugin;
    private String m_logMsg;
    private String m_descr;
    private Integer m_port;
    private String m_protocol;
    private String m_cveEntry;

    public OnmsVulnerability(Integer vulnerabilityId, OnmsNode node, OnmsMonitoredService monitoredService, Date creationTime, Date lastAttemptTime, Date lastScanTime, Date resolvedTime, Integer severity, OnmsVulnPlugin vulnPlugin, int pluginSubId, String logMsg, String descr, Integer port, String protocol, String cveEntry) {
        this.m_vulnerabilityId = vulnerabilityId;
        this.m_node = node;
        this.m_monitoredService = monitoredService;
        this.m_creationTime = creationTime;
        this.m_lastAttemptTime = lastAttemptTime;
        this.m_lastScanTime = lastScanTime;
        this.m_resolvedTime = resolvedTime;
        this.m_severity = severity;
        this.m_vulnPlugin = vulnPlugin;
        this.m_logMsg = logMsg;
        this.m_descr = descr;
        this.m_port = port;
        this.m_protocol = protocol;
        this.m_cveEntry = cveEntry;
    }

    public OnmsVulnerability() {
    }

    public OnmsVulnerability(Integer vulnerabilityId, Date creationTime, Date lastAttemptTime, Date lastScanTime, Integer severity, OnmsVulnPlugin vulnPlugin, Integer pluginSubId) {
        this.m_vulnerabilityId = vulnerabilityId;
        this.m_creationTime = creationTime;
        this.m_lastAttemptTime = lastAttemptTime;
        this.m_lastScanTime = lastScanTime;
        this.m_severity = severity;
        this.m_vulnPlugin = vulnPlugin;
    }

    @Id
    @SequenceGenerator(name="vulnerabilitySequence", sequenceName="vulnerabilityId")
    @GeneratedValue(generator="vulnerabilitySequence")
    @Column(name="vulnerabilityId")
    public Integer getVulnerabilityId() {
        return this.m_vulnerabilityId;
    }

    public void setVulnerabilityId(Integer vulnerabilityId) {
        this.m_vulnerabilityId = vulnerabilityId;
    }

    @ManyToOne
    @JoinColumn(name="nodeid")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @ManyToOne
    @JoinColumn(name="ifServiceId")
    public OnmsMonitoredService getMonitoredService() {
        return this.m_monitoredService;
    }

    public void setMonitoredService(OnmsMonitoredService monitoredService) {
        this.m_monitoredService = monitoredService;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="creationTime", nullable=false)
    public Date getCreationTime() {
        return this.m_creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.m_creationTime = creationTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastAttemptTime", nullable=false)
    public Date getLastAttemptTime() {
        return this.m_lastAttemptTime;
    }

    public void setLastAttemptTime(Date lastAttemptTime) {
        this.m_lastAttemptTime = lastAttemptTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastScanTime", nullable=false)
    public Date getLastScanTime() {
        return this.m_lastScanTime;
    }

    public void setLastScanTime(Date lastScanTime) {
        this.m_lastScanTime = lastScanTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="resolvedTime")
    public Date getResolvedTime() {
        return this.m_resolvedTime;
    }

    public void setResolvedTime(Date resolvedTime) {
        this.m_resolvedTime = resolvedTime;
    }

    @Column(name="severity")
    public Integer getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(Integer severity) {
        this.m_severity = severity;
    }

    @ManyToOne
    @JoinColumn(name="pluginId", nullable=false)
    public OnmsVulnPlugin getVulnPlugin() {
        return this.m_vulnPlugin;
    }

    public void setVulnPlugin(OnmsVulnPlugin vulnPlugin) {
        this.m_vulnPlugin = vulnPlugin;
    }

    @Column(name="logMsg", length=256)
    public String getLogMsg() {
        return this.m_logMsg;
    }

    public void setLogMsg(String logMsg) {
        this.m_logMsg = logMsg;
    }

    @Column(name="descr", length=1024)
    public String getDescr() {
        return this.m_descr;
    }

    public void setDescr(String descr) {
        this.m_descr = descr;
    }

    @Column(name="port")
    public Integer getPort() {
        return this.m_port;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    @Column(name="protocol", length=32)
    public String getProtocol() {
        return this.m_protocol;
    }

    public void setProtocol(String protocol) {
        this.m_protocol = protocol;
    }

    @Column(name="cveEntry", length=14)
    public String getCveEntry() {
        return this.m_cveEntry;
    }

    public void setCveEntry(String cveEntry) {
        this.m_cveEntry = cveEntry;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("vulnerabilityId", (Object)this.getVulnerabilityId()).toString();
    }

    public void visit(EntityVisitor visitor) {
        throw new RuntimeException("visitor method not implemented");
    }
}

