/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.discovery;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPAddress
implements Comparable<IPAddress> {
    long m_ipAddr;

    public IPAddress(IPAddress addr) {
        this.m_ipAddr = addr.m_ipAddr;
    }

    public IPAddress(String dottedNotation) {
        this.m_ipAddr = InetAddressUtils.toIpAddrLong((String)dottedNotation);
    }

    public IPAddress(InetAddress inetAddress) {
        this.m_ipAddr = InetAddressUtils.toIpAddrLong((InetAddress)inetAddress);
    }

    public IPAddress(long ipAddrAs32bitNumber) {
        this.m_ipAddr = ipAddrAs32bitNumber;
    }

    public IPAddress(byte[] ipAddrOctets) {
        this.m_ipAddr = InetAddressUtils.toIpAddrLong((byte[])ipAddrOctets);
    }

    public InetAddress toInetAddress() {
        return InetAddressUtils.getInetAddress((long)this.m_ipAddr);
    }

    public byte[] toOctets() {
        return InetAddressUtils.toIpAddrBytes((long)this.m_ipAddr);
    }

    public long toLong() {
        return this.m_ipAddr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IPAddress) {
            IPAddress other = (IPAddress)obj;
            return this.m_ipAddr == other.m_ipAddr;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.m_ipAddr;
    }

    @Override
    public int compareTo(IPAddress o) {
        IPAddress other = o;
        long result = this.m_ipAddr - other.m_ipAddr;
        if (result < 0L) {
            return -1;
        }
        if (result > 0L) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return InetAddressUtils.toIpAddrString((long)this.m_ipAddr);
    }

    public IPAddress incr() {
        return new IPAddress(this.m_ipAddr + 1L);
    }

    public IPAddress decr() {
        return new IPAddress(this.m_ipAddr - 1L);
    }

    public boolean isPredecessorOf(IPAddress other) {
        return other.decr().equals(this);
    }

    public boolean isSuccessorOf(IPAddress other) {
        return other.incr().equals(this);
    }

    public boolean isLessThan(IPAddress other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(IPAddress other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(IPAddress other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(IPAddress other) {
        return this.compareTo(other) >= 0;
    }

    public static IPAddress min(IPAddress a, IPAddress b) {
        return a.isLessThan(b) ? a : b;
    }

    public static IPAddress max(IPAddress a, IPAddress b) {
        return a.isGreaterThan(b) ? a : b;
    }
}

