/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Category;
import org.opennms.core.utils.AlphaNumeric;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="snmpInterface")
public class OnmsSnmpInterface
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = -5396189389666285305L;
    private Integer m_id;
    private String m_ipAddr;
    private String m_netMask;
    private String m_physAddr;
    private Integer m_ifIndex;
    private String m_ifDescr;
    private Integer m_ifType;
    private String m_ifName;
    private Long m_ifSpeed;
    private Integer m_ifAdminStatus;
    private Integer m_ifOperStatus;
    private String m_ifAlias;
    private OnmsNode m_node;
    private Set<OnmsIpInterface> m_ipInterfaces = new HashSet<OnmsIpInterface>();

    public OnmsSnmpInterface(String ipAddr, int ifIndex, OnmsNode node) {
        this(ipAddr, new Integer(ifIndex), node);
    }

    public OnmsSnmpInterface(String ipaddr, Integer ifIndex, OnmsNode node) {
        this.m_ipAddr = ipaddr;
        this.m_ifIndex = ifIndex;
        this.m_node = node;
        node.getSnmpInterfaces().add(this);
    }

    public OnmsSnmpInterface() {
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="ipAddr", length=16)
    public String getIpAddress() {
        return this.m_ipAddr;
    }

    public void setIpAddress(String ipaddr) {
        this.m_ipAddr = ipaddr;
    }

    @Column(name="snmpIpAdEntNetMask", length=16)
    public String getNetMask() {
        return this.m_netMask;
    }

    public void setNetMask(String snmpipadentnetmask) {
        this.m_netMask = snmpipadentnetmask;
    }

    @Column(name="snmpPhysAddr", length=32)
    public String getPhysAddr() {
        return this.m_physAddr;
    }

    public void setPhysAddr(String snmpphysaddr) {
        this.m_physAddr = snmpphysaddr;
    }

    @Column(name="snmpIfIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer snmpifindex) {
        this.m_ifIndex = snmpifindex;
    }

    @Column(name="snmpIfDescr", length=256)
    public String getIfDescr() {
        return this.m_ifDescr;
    }

    public void setIfDescr(String snmpifdescr) {
        this.m_ifDescr = snmpifdescr;
    }

    @Column(name="snmpIfType")
    public Integer getIfType() {
        return this.m_ifType;
    }

    public void setIfType(Integer snmpiftype) {
        this.m_ifType = snmpiftype;
    }

    @Column(name="snmpIfName", length=32)
    public String getIfName() {
        return this.m_ifName;
    }

    public void setIfName(String snmpifname) {
        this.m_ifName = snmpifname;
    }

    @Column(name="snmpIfSpeed")
    public Long getIfSpeed() {
        return this.m_ifSpeed;
    }

    public void setIfSpeed(Long snmpifspeed) {
        this.m_ifSpeed = snmpifspeed;
    }

    @Column(name="snmpIfAdminStatus")
    public Integer getIfAdminStatus() {
        return this.m_ifAdminStatus;
    }

    public void setIfAdminStatus(Integer snmpifadminstatus) {
        this.m_ifAdminStatus = snmpifadminstatus;
    }

    @Column(name="snmpIfOperStatus")
    public Integer getIfOperStatus() {
        return this.m_ifOperStatus;
    }

    public void setIfOperStatus(Integer snmpifoperstatus) {
        this.m_ifOperStatus = snmpifoperstatus;
    }

    @Column(name="snmpIfAlias", length=256)
    public String getIfAlias() {
        return this.m_ifAlias;
    }

    public void setIfAlias(String snmpifalias) {
        this.m_ifAlias = snmpifalias;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("ipaddr", (Object)this.getIpAddress()).append("snmpipadentnetmask", (Object)this.getNetMask()).append("snmpphysaddr", (Object)this.getPhysAddr()).append("snmpifindex", (Object)this.getIfIndex()).append("snmpifdescr", (Object)this.getIfDescr()).append("snmpiftype", (Object)this.getIfType()).append("snmpifname", (Object)this.getIfName()).append("snmpifspeed", (Object)this.getIfSpeed()).append("snmpifadminstatus", (Object)this.getIfAdminStatus()).append("snmpifoperstatus", (Object)this.getIfOperStatus()).append("snmpifalias", (Object)this.getIfAlias()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitSnmpInterface(this);
        visitor.visitSnmpInterfaceComplete(this);
    }

    @OneToMany(mappedBy="snmpInterface", fetch=FetchType.LAZY)
    public Set<OnmsIpInterface> getIpInterfaces() {
        return this.m_ipInterfaces;
    }

    public void setIpInterfaces(Set<OnmsIpInterface> ipInterfaces) {
        this.m_ipInterfaces = ipInterfaces;
    }

    @Transient
    public OnmsIpInterface.CollectionType getCollectionType() {
        OnmsIpInterface.CollectionType maxCollType = OnmsIpInterface.CollectionType.NO_COLLECT;
        for (OnmsIpInterface ipIface : this.getIpInterfaces()) {
            if (ipIface.getIsSnmpPrimary() == null) continue;
            maxCollType = maxCollType.max(ipIface.getIsSnmpPrimary());
        }
        return maxCollType;
    }

    public Category log() {
        return ThreadCategory.getInstance(this.getClass());
    }

    public String computePhysAddrForRRD() {
        String physAddrForRRD = null;
        if (this.getPhysAddr() != null) {
            String parsedPhysAddr = AlphaNumeric.parseAndTrim((String)this.getPhysAddr());
            if (parsedPhysAddr.length() == 12) {
                physAddrForRRD = parsedPhysAddr;
            } else if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("physAddrForRRD: physical address len is NOT 12, physAddr=" + parsedPhysAddr));
            }
        }
        this.log().debug((Object)("computed physAddr for " + this + " to be " + physAddrForRRD));
        return physAddrForRRD;
    }

    public String computeNameForRRD() {
        String label = null;
        if (this.getIfName() != null) {
            label = AlphaNumeric.parseAndReplace((String)this.getIfName(), (char)'_');
        } else if (this.getIfDescr() != null) {
            label = AlphaNumeric.parseAndReplace((String)this.getIfDescr(), (char)'_');
        } else {
            this.log().info((Object)("Interface (" + this + ") has no ifName and no ifDescr...setting to label to 'no_ifLabel'."));
            label = "no_ifLabel";
        }
        return label;
    }

    public String computeLabelForRRD() {
        String name = this.computeNameForRRD();
        String physAddrForRRD = this.computePhysAddrForRRD();
        return physAddrForRRD == null ? name : name + '-' + physAddrForRRD;
    }

    public void addIpInterface(OnmsIpInterface iface) {
        this.m_ipInterfaces.add(iface);
    }
}

