/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ipInterface")
public class OnmsIpInterface
extends OnmsEntity
implements Serializable {
    private static final long serialVersionUID = 7750043250236397014L;
    private Integer m_id;
    private String m_ipAddress;
    private String m_ipHostName;
    private String m_isManaged;
    private Integer m_ipStatus;
    private Date m_ipLastCapsdPoll;
    private CollectionType m_isSnmpPrimary = CollectionType.NO_COLLECT;
    private OnmsNode m_node;
    private Set<OnmsMonitoredService> m_monitoredServices = new HashSet<OnmsMonitoredService>();
    private OnmsSnmpInterface m_snmpInterface;

    public OnmsIpInterface() {
    }

    public OnmsIpInterface(String ipAddr, OnmsNode node) {
        this.m_ipAddress = ipAddr;
        this.m_node = node;
        node.getIpInterfaces().add(this);
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="ipAddr", length=16)
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipaddr) {
        this.m_ipAddress = ipaddr;
    }

    @Transient
    public Integer getIfIndex() {
        if (this.m_snmpInterface == null) {
            return null;
        }
        return this.m_snmpInterface.getIfIndex();
    }

    public void setIfIndex(Integer ifindex) {
        if (this.m_snmpInterface == null) {
            throw new IllegalStateException("Cannot set ifIndex if snmpInterface relation isn't setup");
        }
        this.m_snmpInterface.setIfIndex(ifindex);
    }

    @Column(name="ipHostName", length=256)
    public String getIpHostName() {
        return this.m_ipHostName;
    }

    public void setIpHostName(String iphostname) {
        this.m_ipHostName = iphostname;
    }

    @Column(name="isManaged", length=1)
    public String getIsManaged() {
        return this.m_isManaged;
    }

    public void setIsManaged(String ismanaged) {
        this.m_isManaged = ismanaged;
    }

    @Column(name="ipStatus")
    public Integer getIpStatus() {
        return this.m_ipStatus;
    }

    public void setIpStatus(Integer ipstatus) {
        this.m_ipStatus = ipstatus;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="ipLastCapsdPoll")
    public Date getIpLastCapsdPoll() {
        return this.m_ipLastCapsdPoll;
    }

    public void setIpLastCapsdPoll(Date iplastcapsdpoll) {
        this.m_ipLastCapsdPoll = iplastcapsdpoll;
    }

    @Column(name="isSnmpPrimary", length=1)
    public CollectionType getIsSnmpPrimary() {
        return this.m_isSnmpPrimary;
    }

    public void setIsSnmpPrimary(CollectionType issnmpprimary) {
        this.m_isSnmpPrimary = issnmpprimary;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @OneToMany(mappedBy="ipInterface")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public Set<OnmsMonitoredService> getMonitoredServices() {
        return this.m_monitoredServices;
    }

    public void setMonitoredServices(Set<OnmsMonitoredService> ifServices) {
        this.m_monitoredServices = ifServices;
    }

    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="snmpInterfaceId")
    public OnmsSnmpInterface getSnmpInterface() {
        return this.m_snmpInterface;
    }

    public void setSnmpInterface(OnmsSnmpInterface snmpInterface) {
        this.m_snmpInterface = snmpInterface;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("ipaddr", (Object)this.getIpAddress()).append("ifindex", (Object)this.getIfIndex()).append("iphostname", (Object)this.getIpHostName()).append("ismanaged", (Object)this.getIsManaged()).append("ipstatus", (Object)this.getIpStatus()).append("iplastcapsdpoll", (Object)this.getIpLastCapsdPoll()).append("issnmpprimary", (Object)this.getIsSnmpPrimary()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitIpInterface(this);
        for (OnmsMonitoredService monSvc : this.getMonitoredServices()) {
            monSvc.visit(visitor);
        }
        visitor.visitIpInterfaceComplete(this);
    }

    @Transient
    public InetAddress getInetAddress() {
        String ipAddr = this.getIpAddress();
        if (ipAddr == null) {
            return null;
        }
        InetAddress addr = null;
        try {
            String hostName = this.getIpHostName() == null ? ipAddr : this.getIpHostName();
            addr = InetAddress.getByName(ipAddr);
            addr = InetAddress.getByAddress(hostName, addr.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return addr;
    }

    @Transient
    public boolean isDown() {
        boolean down = true;
        for (OnmsMonitoredService svc : this.m_monitoredServices) {
            if (svc.isDown()) continue;
            return !down;
        }
        return down;
    }

    public OnmsMonitoredService getMonitoredServiceByServiceType(String svcName) {
        for (OnmsMonitoredService monSvc : this.getMonitoredServices()) {
            if (!monSvc.getServiceType().getName().equals(svcName)) continue;
            return monSvc;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Embeddable
    public static class CollectionType
    implements Comparable<CollectionType>,
    Serializable {
        private static final long serialVersionUID = -647348487361201657L;
        private static final char[] s_order = new char[]{'N', 'C', 'S', 'P'};
        char m_collType = (char)78;
        public static CollectionType PRIMARY = new CollectionType('P');
        public static CollectionType SECONDARY = new CollectionType('S');
        public static CollectionType COLLECT = new CollectionType('C');
        public static CollectionType NO_COLLECT = new CollectionType('N');

        private CollectionType() {
        }

        public CollectionType(char collType) {
            this.m_collType = collType;
        }

        @Column(name="isSnmpPrimary")
        public char getCharCode() {
            return this.m_collType;
        }

        public void setCharCode(char collType) {
            this.m_collType = collType;
        }

        @Override
        public int compareTo(CollectionType collType) {
            return CollectionType.getIndex(this.m_collType) - CollectionType.getIndex(collType.m_collType);
        }

        private static int getIndex(char code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal collType code '" + code + "'");
        }

        public boolean equals(CollectionType o) {
            if (o == null) {
                return false;
            }
            return this.m_collType == o.m_collType;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_collType);
        }

        public boolean isLessThan(CollectionType collType) {
            return this.compareTo(collType) < 0;
        }

        public boolean isGreaterThan(CollectionType collType) {
            return this.compareTo(collType) > 0;
        }

        public CollectionType max(CollectionType collType) {
            return this.isLessThan(collType) ? collType : this;
        }

        public CollectionType min(CollectionType collType) {
            return this.isLessThan(collType) ? this : collType;
        }

        public static CollectionType get(char code) {
            switch (code) {
                case 'P': {
                    return PRIMARY;
                }
                case 'S': {
                    return SECONDARY;
                }
                case 'C': {
                    return COLLECT;
                }
                case 'N': {
                    return NO_COLLECT;
                }
            }
            throw new IllegalArgumentException("Cannot create collType from code " + code);
        }

        public static CollectionType get(String code) {
            if (code == null) {
                return NO_COLLECT;
            }
            if ((code = code.trim()).length() < 1) {
                return NO_COLLECT;
            }
            if (code.length() > 1) {
                throw new IllegalArgumentException("Cannot convert string " + code + " to a collType");
            }
            return CollectionType.get(code.charAt(0));
        }
    }
}

