/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.core.style.ToStringCreator;

@Entity
@Table(name="atInterface")
public class OnmsArpInterface
implements Serializable {
    private static final long serialVersionUID = 7750043250236397014L;
    private Integer m_id;
    private OnmsNode m_node;
    private String m_ipAddress;
    private String m_physAddr;
    private StatusType m_status = StatusType.UNKNOWN;
    private OnmsNode m_sourceNode;
    private Integer m_ifIndex;
    private Date m_lastPoll;

    public OnmsArpInterface() {
    }

    public OnmsArpInterface(String ipAddr, String physAddr, OnmsNode node) {
        this.m_ipAddress = ipAddr;
        this.m_physAddr = physAddr;
        this.m_node = node;
        node.getArpInterfaces().add(this);
    }

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="ipAddr", length=16)
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipaddr) {
        this.m_ipAddress = ipaddr;
    }

    @Column(name="atPhysAddr", length=32)
    public String getPhysAddr() {
        return this.m_physAddr;
    }

    public void setPhysAddr(String physAddr) {
        this.m_physAddr = physAddr;
    }

    @Column(name="status", length=1)
    public StatusType getStatus() {
        return this.m_status;
    }

    public void setStatus(StatusType status) {
        this.m_status = status;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="sourceNodeId")
    public OnmsNode getSourceNode() {
        return this.m_sourceNode;
    }

    public void setSourceNode(OnmsNode sourceNode) {
        this.m_sourceNode = sourceNode;
    }

    @Column(name="ifIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastPollTime")
    public Date getLastPoll() {
        return this.m_lastPoll;
    }

    public void setLastPoll(Date lastPoll) {
        this.m_lastPoll = lastPoll;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("ipaddr", (Object)this.getIpAddress()).append("physaddr", (Object)this.getPhysAddr()).append("status", (Object)this.getStatus()).append("sourcenode", (Object)this.getSourceNode()).append("ifindex", (Object)this.getIfIndex()).append("lastpoll", (Object)this.getLastPoll()).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Embeddable
    public static class StatusType
    implements Comparable<StatusType>,
    Serializable {
        private static final long serialVersionUID = -4784344871599250528L;
        private static final char[] s_order = new char[]{'A', 'N', 'D', 'K'};
        private char m_statusType;
        public static StatusType ACTIVE = new StatusType('A');
        public static StatusType INACTIVE = new StatusType('N');
        public static StatusType DELETED = new StatusType('D');
        public static StatusType UNKNOWN = new StatusType('K');

        private StatusType() {
        }

        public StatusType(char statusType) {
            this.m_statusType = statusType;
        }

        @Column(name="status")
        public char getCharCode() {
            return this.m_statusType;
        }

        public void setCharCode(char statusType) {
            this.m_statusType = statusType;
        }

        @Override
        public int compareTo(StatusType o) {
            return StatusType.getIndex(this.m_statusType) - StatusType.getIndex(o.m_statusType);
        }

        private static int getIndex(char code) {
            for (int i = 0; i < s_order.length; ++i) {
                if (s_order[i] != code) continue;
                return i;
            }
            throw new IllegalArgumentException("illegal statusType code '" + code + "'");
        }

        public boolean equals(Object o) {
            if (o instanceof StatusType) {
                return this.m_statusType == ((StatusType)o).m_statusType;
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return String.valueOf(this.m_statusType);
        }

        public static StatusType get(char code) {
            switch (code) {
                case 'A': {
                    return ACTIVE;
                }
                case 'N': {
                    return INACTIVE;
                }
                case 'D': {
                    return DELETED;
                }
                case 'K': {
                    return UNKNOWN;
                }
            }
            throw new IllegalArgumentException("Cannot create statusType from code " + code);
        }

        public static StatusType get(String code) {
            if (code == null) {
                return UNKNOWN;
            }
            if ((code = code.trim()).length() < 1) {
                return UNKNOWN;
            }
            if (code.length() > 1) {
                throw new IllegalArgumentException("Cannot convert string " + code + " to a StatusType");
            }
            return StatusType.get(code.charAt(0));
        }
    }
}

