/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opennms.netmgt.model.events.EventListener;
import org.opennms.netmgt.model.events.EventSubscriptionService;
import org.opennms.netmgt.model.events.StoppableEventListener;
import org.opennms.netmgt.model.events.annotations.EventExceptionHandler;
import org.opennms.netmgt.model.events.annotations.EventHandler;
import org.opennms.netmgt.model.events.annotations.EventPostProcessor;
import org.opennms.netmgt.model.events.annotations.EventPreProcessor;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationBasedEventListenerAdapter
implements StoppableEventListener,
InitializingBean,
DisposableBean {
    private volatile String m_name = null;
    private volatile Object m_annotatedListener;
    private volatile EventSubscriptionService m_subscriptionService;
    private final Map<String, Method> m_ueiToHandlerMap = new HashMap<String, Method>();
    private final List<Method> m_eventPreProcessors = new LinkedList<Method>();
    private final List<Method> m_eventPostProcessors = new LinkedList<Method>();
    private final SortedSet<Method> m_exceptionHandlers = new TreeSet<Method>(this.createExceptionHandlerComparator());

    public AnnotationBasedEventListenerAdapter(String name, Object annotatedListener, EventSubscriptionService subscriptionService) {
        this.m_name = name;
        this.m_annotatedListener = annotatedListener;
        this.m_subscriptionService = subscriptionService;
        this.afterPropertiesSet();
    }

    public AnnotationBasedEventListenerAdapter(Object annotatedListener, EventSubscriptionService subscriptionService) {
        this(null, annotatedListener, subscriptionService);
    }

    public AnnotationBasedEventListenerAdapter() {
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public void onEvent(Event event) {
        if (event.getUei() == null) {
            return;
        }
        Method method = this.m_ueiToHandlerMap.get(event.getUei());
        if (method == null) {
            throw new IllegalArgumentException("Received an event for which we have no handler!");
        }
        try {
            this.preprocessEvent(event);
            this.processEvent(event, method);
            this.postprocessEvent(event);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (InvocationTargetException e) {
            this.handleException(event, e.getCause());
        }
    }

    protected void postprocessEvent(Event event) throws IllegalAccessException, InvocationTargetException {
        for (Method m : this.m_eventPostProcessors) {
            this.processEvent(event, m);
        }
    }

    protected void processEvent(Event event, Method method) throws IllegalAccessException, InvocationTargetException {
        method.invoke(this.m_annotatedListener, event);
    }

    protected void preprocessEvent(Event event) throws IllegalAccessException, InvocationTargetException {
        for (Method m : this.m_eventPreProcessors) {
            this.processEvent(event, m);
        }
    }

    protected void handleException(Event event, Throwable cause) {
        for (Method method : this.m_exceptionHandlers) {
            if (!ClassUtils.isAssignableValue(method.getParameterTypes()[1], (Object)cause)) continue;
            try {
                method.invoke(this.m_annotatedListener, event, cause);
                break;
            }
            catch (Exception e) {
                throw new UndeclaredThrowableException(e);
            }
        }
    }

    public void setAnnotatedListener(Object annotatedListener) {
        this.m_annotatedListener = annotatedListener;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_subscriptionService != null ? 1 : 0) != 0, (String)"subscriptionService must be set");
        Assert.state((this.m_annotatedListener != null ? 1 : 0) != 0, (String)"must set the annotatedListener property");
        org.opennms.netmgt.model.events.annotations.EventListener listenerInfo = this.findEventListenerAnnotation(this.m_annotatedListener);
        Assert.state((listenerInfo != null ? 1 : 0) != 0, (String)("value of annotatedListener property of class " + this.m_annotatedListener.getClass() + " must be annotated as " + org.opennms.netmgt.model.events.annotations.EventListener.class.getName()));
        if (this.m_name == null) {
            this.m_name = listenerInfo.name();
        }
        this.populatePreProcessorList();
        this.populateUeiToHandlerMap();
        this.populatePostProcessorList();
        this.populateExeptionHandlersSet();
        this.m_subscriptionService.addEventListener((EventListener)this, new HashSet<String>(this.m_ueiToHandlerMap.keySet()));
    }

    private org.opennms.netmgt.model.events.annotations.EventListener findEventListenerAnnotation(Object annotatedListener) {
        return annotatedListener.getClass().getAnnotation(org.opennms.netmgt.model.events.annotations.EventListener.class);
    }

    private void populateExeptionHandlersSet() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(EventExceptionHandler.class)) continue;
            this.validateMethodAsEventExceptionHandler(method);
            this.m_exceptionHandlers.add(method);
        }
    }

    private void validateMethodAsEventExceptionHandler(Method method) {
        Assert.state((method.getParameterTypes().length == 2 ? 1 : 0) != 0, (String)"Invalid number of paremeters. EventExceptionHandler methods must take 2 arguments with types (Event, ? extends Throwable)");
        Assert.state((boolean)ClassUtils.isAssignable(Event.class, method.getParameterTypes()[0]), (String)"First parameter of incorrent type. EventExceptionHandler first paramenter must be of type Event");
        Assert.state((boolean)ClassUtils.isAssignable(Throwable.class, method.getParameterTypes()[1]), (String)"Second parameter of incorrent type. EventExceptionHandler second paramenter must be of type ? extends Throwable");
    }

    private Comparator<Method> createExceptionHandlerComparator() {
        final ClassComparator classComparator = new ClassComparator();
        Comparator<Method> comparator = new Comparator<Method>(){

            @Override
            public int compare(Method left, Method right) {
                Class<Throwable> lhsType = left.getParameterTypes()[1].asSubclass(Throwable.class);
                Class<Throwable> rhsType = right.getParameterTypes()[1].asSubclass(Throwable.class);
                EventExceptionHandler leftHandlerInfo = (EventExceptionHandler)AnnotationUtils.findAnnotation((Method)left, EventExceptionHandler.class);
                EventExceptionHandler rightHandlerInfo = (EventExceptionHandler)AnnotationUtils.findAnnotation((Method)right, EventExceptionHandler.class);
                if (leftHandlerInfo.order() == rightHandlerInfo.order()) {
                    return classComparator.compare(lhsType, rhsType);
                }
                return leftHandlerInfo.order() - rightHandlerInfo.order();
            }
        };
        return comparator;
    }

    private void populatePostProcessorList() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            if (!method.isAnnotationPresent(EventPostProcessor.class)) continue;
            this.validateMethodAsEventHandler(method);
            this.m_eventPostProcessors.add(method);
        }
    }

    private void populatePreProcessorList() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            EventPreProcessor ann = (EventPreProcessor)AnnotationUtils.findAnnotation((Method)method, EventPreProcessor.class);
            if (ann == null) continue;
            this.validateMethodAsEventHandler(method);
            this.m_eventPreProcessors.add(method);
        }
    }

    private void populateUeiToHandlerMap() {
        Method[] methods;
        for (Method method : methods = this.m_annotatedListener.getClass().getMethods()) {
            EventHandler handlerInfo = (EventHandler)AnnotationUtils.findAnnotation((Method)method, EventHandler.class);
            if (handlerInfo == null) continue;
            String uei = handlerInfo.uei();
            Assert.state((!this.m_ueiToHandlerMap.containsKey(uei) ? 1 : 0) != 0, (String)("Cannot define method " + method + " as a handler for event " + uei + " since " + this.m_ueiToHandlerMap.get(uei) + " is already defined as a handler"));
            this.validateMethodAsEventHandler(method);
            this.m_ueiToHandlerMap.put(uei, method);
        }
        Assert.state((!this.m_ueiToHandlerMap.isEmpty() ? 1 : 0) != 0, (String)"annotatedListener must have public EventHandler annotated methods");
    }

    private void validateMethodAsEventHandler(Method method) {
        Assert.state((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)("Invalid number of paremeters for method " + method + ". EventHandler methods must take a single event argument"));
        Assert.state((boolean)method.getParameterTypes()[0].isAssignableFrom(Event.class), (String)("Parameter of incorrent type for method " + method + ". EventHandler methods must take a single event argument"));
    }

    @Override
    public void stop() {
        this.m_subscriptionService.removeEventListener(this);
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void setEventSubscriptionService(EventSubscriptionService subscriptionService) {
        this.m_subscriptionService = subscriptionService;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassComparator<T>
    implements Comparator<Class<? extends T>> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class<? extends T> lhsType, Class<? extends T> rhsType) {
            return ClassUtils.isAssignable(lhsType, rhsType) ? 1 : -1;
        }
    }
}

