/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;

@Embeddable
public class PollStatus
implements Serializable {
    Date m_timestamp = new Date();
    int m_statusCode;
    String m_reason;
    long m_responseTime = -1L;
    public static final int SERVICE_UNRESPONSIVE = 3;
    public static final int SERVICE_UNAVAILABLE = 2;
    public static final int SERVICE_AVAILABLE = 1;
    public static final int SERVICE_UNKNOWN = 0;
    private static final String[] s_statusNames = new String[]{"Unknown", "Up", "Down", "Unresponsive"};

    private static int decodeStatusName(String statusName) {
        for (int statusCode = 0; statusCode < s_statusNames.length; ++statusCode) {
            if (!s_statusNames[statusCode].equalsIgnoreCase(statusName)) continue;
            return statusCode;
        }
        return 0;
    }

    public static PollStatus decode(String statusName) {
        return PollStatus.decode(statusName, null, -1L);
    }

    public static PollStatus decode(String statusName, String reason) {
        return PollStatus.decode(statusName, reason, -1L);
    }

    public static PollStatus decode(String statusName, long responseTime) {
        return PollStatus.decode(statusName, null, responseTime);
    }

    public static PollStatus decode(String statusName, String reason, long responseTime) {
        return new PollStatus(PollStatus.decodeStatusName(statusName), reason, responseTime);
    }

    public static PollStatus get(int status, String reason) {
        return PollStatus.get(status, reason, -1L);
    }

    public static PollStatus get(int status, String reason, long responseTime) {
        return new PollStatus(status, reason, responseTime);
    }

    private PollStatus() {
        this(0, null, -1L);
    }

    private PollStatus(int statusCode, String reason, long responseTime) {
        this.m_statusCode = statusCode;
        this.m_reason = reason;
        this.m_responseTime = responseTime;
    }

    public static PollStatus up() {
        return PollStatus.up(-1L);
    }

    public static PollStatus up(long responseTime) {
        return PollStatus.available(responseTime);
    }

    public static PollStatus available() {
        return PollStatus.available(-1L);
    }

    public static PollStatus available(long responseTime) {
        return new PollStatus(1, null, responseTime);
    }

    public static PollStatus unknown() {
        return PollStatus.unknown(null);
    }

    public static PollStatus unknown(String reason) {
        return new PollStatus(0, reason, -1L);
    }

    public static PollStatus unresponsive() {
        return PollStatus.unresponsive(null);
    }

    public static PollStatus unresponsive(String reason) {
        return new PollStatus(3, reason, -1L);
    }

    public static PollStatus down() {
        return PollStatus.down(null);
    }

    public static PollStatus unavailable() {
        return PollStatus.unavailable(null);
    }

    public static PollStatus down(String reason) {
        return PollStatus.unavailable(reason);
    }

    public static PollStatus unavailable(String reason) {
        return new PollStatus(2, reason, -1L);
    }

    public boolean equals(Object o) {
        if (o instanceof PollStatus) {
            return this.m_statusCode == ((PollStatus)o).m_statusCode;
        }
        return false;
    }

    public int hashCode() {
        return this.m_statusCode;
    }

    @Transient
    public boolean isUp() {
        return !this.isDown();
    }

    @Transient
    public boolean isAvailable() {
        return this.m_statusCode == 1;
    }

    @Transient
    public boolean isUnresponsive() {
        return this.m_statusCode == 3;
    }

    @Transient
    public boolean isUnavailable() {
        return this.m_statusCode == 2;
    }

    @Transient
    public boolean isDown() {
        return this.m_statusCode == 2;
    }

    public String toString() {
        return this.getStatusName();
    }

    @Column(name="statusTime", nullable=false)
    public Date getTimestamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    @Column(name="statusReason", length=255, nullable=true)
    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String reason) {
        this.m_reason = reason;
    }

    @Column(name="responseTime", nullable=true)
    public long getResponseTime() {
        return this.m_responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.m_responseTime = responseTime;
    }

    @Column(name="statusCode", nullable=false)
    public int getStatusCode() {
        return this.m_statusCode;
    }

    private void setStatusCode(int statusCode) {
        this.m_statusCode = statusCode;
    }

    @Transient
    public String getStatusName() {
        return s_statusNames[this.m_statusCode];
    }
}

