/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnmsResource
implements Comparable<OnmsResource> {
    private String m_name;
    private Set<OnmsAttribute> m_attributes;
    private String m_label;
    private OnmsResourceType m_resourceType;
    private List<OnmsResource> m_resources;
    private OnmsResource m_parent = null;

    public OnmsResource(String name, String label, OnmsResourceType resourceType, Set<OnmsAttribute> attributes) {
        this.m_name = name;
        this.m_label = label;
        this.m_resourceType = resourceType;
        this.m_attributes = attributes;
        this.m_resources = new LinkedList<OnmsResource>();
    }

    public OnmsResource(String name, String label, OnmsResourceType resourceType, Set<OnmsAttribute> attributes, List<OnmsResource> resources) {
        this.m_name = name;
        this.m_label = label;
        this.m_resourceType = resourceType;
        this.m_attributes = attributes;
        this.m_resources = resources;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLabel() {
        return this.m_label;
    }

    public OnmsResourceType getResourceType() {
        return this.m_resourceType;
    }

    public Set<OnmsAttribute> getAttributes() {
        return this.m_attributes;
    }

    public List<OnmsResource> getChildResources() {
        return this.m_resources;
    }

    @Override
    public int compareTo(OnmsResource o) {
        return this.getLabel().compareTo(o.getLabel());
    }

    public static List<OnmsResource> sortIntoResourceList(List<OnmsResource> resources) {
        Collections.sort(resources);
        ArrayList<OnmsResource> outputResources = new ArrayList<OnmsResource>(resources.size());
        for (OnmsResource resource : resources) {
            outputResources.add(resource);
        }
        return outputResources;
    }

    public void setParent(OnmsResource parent) {
        this.m_parent = parent;
    }

    public OnmsResource getParent() {
        return this.m_parent;
    }

    public String getId() {
        String thisId = OnmsResource.encode(this.m_resourceType.getName()) + "[" + OnmsResource.encode(this.m_name) + "]";
        if (this.getParent() != null) {
            return this.getParent().getId() + "." + thisId;
        }
        return thisId;
    }

    public String getLink() {
        return this.m_resourceType.getLinkForResource(this);
    }

    public static String createResourceId(String ... resources) {
        if (resources.length % 2 != 0) {
            throw new IllegalArgumentException("Values passed as resources parameter must be in pairs");
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < resources.length / 2; ++i) {
            if (buf.length() > 0) {
                buf.append(".");
            }
            buf.append(resources[i * 2]);
            buf.append("[");
            buf.append(OnmsResource.encode(resources[i * 2 + 1]));
            buf.append("]");
        }
        return buf.toString();
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

