/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsUserNotification;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="notifications")
public class OnmsNotification {
    private static final long serialVersionUID = -1162549324168290004L;
    private Integer m_notifyId;
    private String m_textMsg;
    private String m_subject;
    private String m_numericMsg;
    private Date m_pageTime;
    private Date m_respondTime;
    private String m_answeredBy;
    private OnmsServiceType m_serviceType;
    private String m_queueId;
    private OnmsEvent m_event;
    private OnmsNode m_node;
    private Set<OnmsUserNotification> m_usersNotified = new HashSet<OnmsUserNotification>();
    private String m_ipAddress;
    private String m_notifConfigName;

    public OnmsNotification(Integer notifyId, String textMsg, String subject, String numericMsg, Date pageTime, Date respondTime, String answeredBy, String ipAddress, OnmsServiceType serviceType, String queueId, OnmsEvent event, OnmsNode node, Set<OnmsUserNotification> usersNotified, String notifConfigName) {
        this.m_notifyId = notifyId;
        this.m_textMsg = textMsg;
        this.m_subject = subject;
        this.m_numericMsg = numericMsg;
        this.m_pageTime = pageTime;
        this.m_respondTime = respondTime;
        this.m_answeredBy = answeredBy;
        this.m_ipAddress = ipAddress;
        this.m_serviceType = serviceType;
        this.m_queueId = queueId;
        this.m_event = event;
        this.m_node = node;
        this.m_usersNotified = usersNotified;
        this.m_notifConfigName = notifConfigName;
    }

    public OnmsNotification() {
    }

    public OnmsNotification(Integer notifyId, String textMsg, OnmsEvent event, OnmsNode node, Set<OnmsUserNotification> usersNotified) {
        this.m_notifyId = notifyId;
        this.m_textMsg = textMsg;
        this.m_event = event;
        this.m_node = node;
        this.m_usersNotified = usersNotified;
    }

    @Id
    @SequenceGenerator(name="notifySequence", sequenceName="notifyNxtId")
    @GeneratedValue(generator="notifySequence")
    public Integer getNotifyId() {
        return this.m_notifyId;
    }

    public void setNotifyId(Integer notifyid) {
        this.m_notifyId = notifyid;
    }

    @Column(name="textMsg", length=4000, nullable=false)
    public String getTextMsg() {
        return this.m_textMsg;
    }

    public void setTextMsg(String textmsg) {
        this.m_textMsg = textmsg;
    }

    @Column(name="subject", length=256)
    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    @Column(name="numericMsg", length=256)
    public String getNumericMsg() {
        return this.m_numericMsg;
    }

    public void setNumericMsg(String numericmsg) {
        this.m_numericMsg = numericmsg;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="pageTime")
    public Date getPageTime() {
        return this.m_pageTime;
    }

    public void setPageTime(Date pagetime) {
        this.m_pageTime = pagetime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="respondTime")
    public Date getRespondTime() {
        return this.m_respondTime;
    }

    public void setRespondTime(Date respondtime) {
        this.m_respondTime = respondtime;
    }

    @Column(name="answeredBy", length=256)
    public String getAnsweredBy() {
        return this.m_answeredBy;
    }

    public void setAnsweredBy(String answeredby) {
        this.m_answeredBy = answeredby;
    }

    @Column(name="interfaceId", length=16)
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @ManyToOne
    @JoinColumn(name="serviceId")
    public OnmsServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(OnmsServiceType serviceType) {
        this.m_serviceType = serviceType;
    }

    @Column(name="queueId", length=256)
    public String getQueueId() {
        return this.m_queueId;
    }

    public void setQueueId(String queueid) {
        this.m_queueId = queueid;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eventId", nullable=false)
    public OnmsEvent getEvent() {
        return this.m_event;
    }

    public void setEvent(OnmsEvent event) {
        this.m_event = event;
    }

    @Column(name="eventUEI")
    public String getEventUei() {
        return this.m_event.getEventUei();
    }

    public void setEventUei(String eventUei) {
    }

    @ManyToOne
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @OneToMany(mappedBy="notification", fetch=FetchType.LAZY)
    public Set<OnmsUserNotification> getUsersNotified() {
        return this.m_usersNotified;
    }

    public void setUsersNotified(Set<OnmsUserNotification> usersnotifieds) {
        this.m_usersNotified = usersnotifieds;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("notifyid", (Object)this.getNotifyId()).toString();
    }

    public String getNotifConfigName() {
        return this.m_notifConfigName;
    }

    @Column(name="notifConfigName", length=63)
    public void setNotifConfigName(String notifConfigName) {
        this.m_notifConfigName = notifConfigName;
    }
}

