/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.core.style.ToStringCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="node")
public class OnmsNode
extends OnmsEntity
implements Serializable,
Comparable<OnmsNode> {
    private static final long serialVersionUID = -5736397583719151493L;
    private Integer m_id;
    private Date m_createTime = new Date();
    private OnmsNode m_parent;
    private String m_type;
    private String m_sysObjectId;
    private String m_sysName;
    private String m_sysDescription;
    private String m_sysLocation;
    private String m_sysContact;
    private String m_label;
    private String m_labelSource;
    private String m_netBiosName;
    private String m_netBiosDomain;
    private String m_operatingSystem;
    private Date m_lastCapsdPoll;
    private String m_foreignSource;
    private String m_foreignId;
    private OnmsDistPoller m_distPoller;
    private OnmsAssetRecord m_assetRecord;
    private Set<OnmsIpInterface> m_ipInterfaces = new LinkedHashSet<OnmsIpInterface>();
    private Set<OnmsSnmpInterface> m_snmpInterfaces = new LinkedHashSet<OnmsSnmpInterface>();
    private Set<OnmsCategory> m_categories = new LinkedHashSet<OnmsCategory>();

    public OnmsNode() {
        this(null);
    }

    public OnmsNode(OnmsDistPoller distPoller) {
        this.m_distPoller = distPoller;
        this.m_assetRecord = new OnmsAssetRecord();
        this.m_assetRecord.setNode(this);
    }

    @Id
    @Column(name="nodeId")
    @SequenceGenerator(name="nodeSequence", sequenceName="nodeNxtId")
    @GeneratedValue(generator="nodeSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer nodeid) {
        this.m_id = nodeid;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="nodeCreateTime", nullable=false)
    public Date getCreateTime() {
        return this.m_createTime;
    }

    public void setCreateTime(Date nodecreatetime) {
        this.m_createTime = nodecreatetime;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeParentID")
    public OnmsNode getParent() {
        return this.m_parent;
    }

    public void setParent(OnmsNode parent) {
        this.m_parent = parent;
    }

    @Column(name="nodeType", length=1)
    public String getType() {
        return this.m_type;
    }

    public void setType(String nodetype) {
        this.m_type = nodetype;
    }

    @Column(name="nodeSysOID", length=256)
    public String getSysObjectId() {
        return this.m_sysObjectId;
    }

    public void setSysObjectId(String nodesysoid) {
        this.m_sysObjectId = nodesysoid;
    }

    @Column(name="nodeSysName", length=256)
    public String getSysName() {
        return this.m_sysName;
    }

    public void setSysName(String nodesysname) {
        this.m_sysName = nodesysname;
    }

    @Column(name="nodeSysDescription", length=256)
    public String getSysDescription() {
        return this.m_sysDescription;
    }

    public void setSysDescription(String nodesysdescription) {
        this.m_sysDescription = nodesysdescription;
    }

    @Column(name="nodeSysLocation", length=256)
    public String getSysLocation() {
        return this.m_sysLocation;
    }

    public void setSysLocation(String nodesyslocation) {
        this.m_sysLocation = nodesyslocation;
    }

    @Column(name="nodeSysContact", length=256)
    public String getSysContact() {
        return this.m_sysContact;
    }

    public void setSysContact(String nodesyscontact) {
        this.m_sysContact = nodesyscontact;
    }

    @Column(name="nodeLabel", length=256)
    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String nodelabel) {
        this.m_label = nodelabel;
    }

    @Column(name="nodeLabelSource", length=1)
    public String getLabelSource() {
        return this.m_labelSource;
    }

    public void setLabelSource(String nodelabelsource) {
        this.m_labelSource = nodelabelsource;
    }

    @Column(name="nodeNetBIOSName", length=16)
    public String getNetBiosName() {
        return this.m_netBiosName;
    }

    public void setNetBiosName(String nodenetbiosname) {
        this.m_netBiosName = nodenetbiosname;
    }

    @Column(name="nodeDomainName", length=16)
    public String getNetBiosDomain() {
        return this.m_netBiosDomain;
    }

    public void setNetBiosDomain(String nodedomainname) {
        this.m_netBiosDomain = nodedomainname;
    }

    @Column(name="operatingSystem", length=64)
    public String getOperatingSystem() {
        return this.m_operatingSystem;
    }

    public void setOperatingSystem(String operatingsystem) {
        this.m_operatingSystem = operatingsystem;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastCapsdPoll")
    public Date getLastCapsdPoll() {
        return this.m_lastCapsdPoll;
    }

    public void setLastCapsdPoll(Date lastcapsdpoll) {
        this.m_lastCapsdPoll = lastcapsdpoll;
    }

    @Column(name="foreignId")
    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setForeignId(String foreignId) {
        this.m_foreignId = foreignId;
    }

    @Column(name="foreignSource")
    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="dpName")
    public OnmsDistPoller getDistPoller() {
        return this.m_distPoller;
    }

    public void setDistPoller(OnmsDistPoller distpoller) {
        this.m_distPoller = distpoller;
    }

    @OneToOne(mappedBy="node", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    public OnmsAssetRecord getAssetRecord() {
        return this.m_assetRecord;
    }

    public void setAssetRecord(OnmsAssetRecord asset) {
        this.m_assetRecord = asset;
    }

    @OneToMany(mappedBy="node")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<OnmsIpInterface> getIpInterfaces() {
        return this.m_ipInterfaces;
    }

    public void setIpInterfaces(Set<OnmsIpInterface> ipinterfaces) {
        this.m_ipInterfaces = ipinterfaces;
    }

    public void addIpInterface(OnmsIpInterface iface) {
        iface.setNode(this);
        this.getIpInterfaces().add(iface);
    }

    @OneToMany(mappedBy="node")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Set<OnmsSnmpInterface> getSnmpInterfaces() {
        return this.m_snmpInterfaces;
    }

    public void setSnmpInterfaces(Set<OnmsSnmpInterface> snmpinterfaces) {
        this.m_snmpInterfaces = snmpinterfaces;
    }

    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinTable(name="category_node", joinColumns={@JoinColumn(name="nodeId")}, inverseJoinColumns={@JoinColumn(name="categoryId")})
    public Set<OnmsCategory> getCategories() {
        return this.m_categories;
    }

    public void setCategories(Set<OnmsCategory> categories) {
        this.m_categories = categories;
    }

    public boolean addCategory(OnmsCategory category) {
        return this.getCategories().add(category);
    }

    public boolean removeCategory(OnmsCategory category) {
        return this.getCategories().remove(category);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.getId()).append("label", (Object)this.getLabel()).toString();
    }

    @Override
    public void visit(EntityVisitor visitor) {
        visitor.visitNode(this);
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            iface.visit(visitor);
        }
        for (OnmsSnmpInterface snmpIface : this.getSnmpInterfaces()) {
            snmpIface.visit(visitor);
        }
        visitor.visitNodeComplete(this);
    }

    public void addSnmpInterface(OnmsSnmpInterface snmpIface) {
        snmpIface.setNode(this);
        this.getSnmpInterfaces().add(snmpIface);
    }

    @Transient
    public boolean isDown() {
        boolean down = true;
        for (OnmsIpInterface ipIf : this.m_ipInterfaces) {
            if (ipIf.isDown()) continue;
            return !down;
        }
        return down;
    }

    @Transient
    public OnmsSnmpInterface getSnmpInterfaceWithIfIndex(int ifIndex) {
        for (OnmsSnmpInterface dbSnmpIface : this.getSnmpInterfaces()) {
            if (!dbSnmpIface.getIfIndex().equals(ifIndex)) continue;
            return dbSnmpIface;
        }
        return null;
    }

    public OnmsIpInterface getIpInterfaceByIpAddress(String ipAddress) {
        for (OnmsIpInterface iface : this.getIpInterfaces()) {
            if (!ipAddress.equals(iface.getIpAddress())) continue;
            return iface;
        }
        return null;
    }

    @Override
    public int compareTo(OnmsNode o) {
        return this.getLabel().compareToIgnoreCase(o.getLabel());
    }
}

