/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="location_monitors")
public class OnmsLocationMonitor {
    private Integer m_id;
    private MonitorStatus m_status = MonitorStatus.NEW;
    private Date m_lastCheckInTime;
    private String m_definitionName;
    private Map<String, String> m_details;

    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="definitionName", length=31, nullable=false)
    public String getDefinitionName() {
        return this.m_definitionName;
    }

    public void setDefinitionName(String definitionName) {
        this.m_definitionName = definitionName;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="status", length=13, nullable=false)
    public MonitorStatus getStatus() {
        return this.m_status;
    }

    public void setStatus(MonitorStatus status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastCheckInTime")
    public Date getLastCheckInTime() {
        return this.m_lastCheckInTime;
    }

    public void setLastCheckInTime(Date lastCheckInTime) {
        this.m_lastCheckInTime = lastCheckInTime;
    }

    @Transient
    public String getName() {
        return this.m_definitionName + '-' + this.getId();
    }

    @CollectionOfElements
    @JoinTable(name="location_monitor_details", joinColumns={@JoinColumn(name="locationMonitorId")})
    @MapKey(columns={@Column(name="property")})
    @Column(name="propertyValue", nullable=false)
    public Map<String, String> getDetails() {
        return this.m_details;
    }

    public void setDetails(Map<String, String> pollerDetails) {
        this.m_details = pollerDetails;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MonitorStatus {
        NEW,
        REGISTERED,
        STARTED,
        STOPPED,
        UNRESPONSIVE,
        DELETED;

    }
}

