//
// This file is part of the OpenNMS(R) Application.
//
// OpenNMS(R) is Copyright (C) 2006 The OpenNMS Group, Inc.  All rights reserved.
// OpenNMS(R) is a derivative work, containing both original code, included code and modified
// code that was published under the GNU General Public License. Copyrights for modified 
// and included code are below.
//
// OpenNMS(R) is a registered trademark of The OpenNMS Group, Inc.
//
// Original code base Copyright (C) 1999-2001 Oculan Corp.  All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// For more information contact:
// OpenNMS Licensing       <license@opennms.org>
//     http://www.opennms.org/
//     http://www.opennms.com/
//
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.springframework.core.style.ToStringCreator;


@Entity
@Table(name="vulnerabilities")
public class OnmsVulnerability extends OnmsEntity implements Serializable {

    /**
     * 
     */
    private static final long serialVersionUID = -2212905105927237801L;

    /** identifier field */
    private Integer m_vulnerabilityId;

    /** nullable persistent field */
    private OnmsNode m_node;

    /** nullable persistent field */
    private OnmsMonitoredService m_monitoredService;   

    /** persistent field */
    private Date m_creationTime;

    /** persistent field */
    private Date m_lastAttemptTime;

    /** persistent field */
    private Date m_lastScanTime;

    /** nullable persistent field */
    private Date m_resolvedTime;

    /** persistent field */
    private Integer m_severity;

    /** persistent field */
    private OnmsVulnPlugin m_vulnPlugin;

    /** nullable persistent field */
    private String m_logMsg;

    /** nullable persistent field */
    private String m_descr;

    /** nullable persistent field */
    private Integer m_port;

    /** nullable persistent field */
    private String m_protocol;

    /** nullable persistent field */
    private String m_cveEntry;

    /** full constructor */
    public OnmsVulnerability(Integer vulnerabilityId, OnmsNode node, OnmsMonitoredService monitoredService, Date creationTime, Date lastAttemptTime, Date lastScanTime, Date resolvedTime, Integer severity, OnmsVulnPlugin vulnPlugin, int pluginSubId, String logMsg, String descr, Integer port, String protocol, String cveEntry) {
        m_vulnerabilityId = vulnerabilityId;
        m_node = node;
        m_monitoredService = monitoredService;
        m_creationTime = creationTime;
        m_lastAttemptTime = lastAttemptTime;
        m_lastScanTime = lastScanTime;
        m_resolvedTime = resolvedTime;
        m_severity = severity;
        m_vulnPlugin = vulnPlugin;
        m_logMsg = logMsg;
        m_descr = descr;
        m_port = port;
        m_protocol = protocol;
        m_cveEntry = cveEntry;
    }

    /** default constructor */
    public OnmsVulnerability() {
    }

    /** minimal constructor */
    public OnmsVulnerability(Integer vulnerabilityId, Date creationTime, Date lastAttemptTime, Date lastScanTime, Integer severity, OnmsVulnPlugin vulnPlugin, Integer pluginSubId) {
        m_vulnerabilityId = vulnerabilityId;
        m_creationTime = creationTime;
        m_lastAttemptTime = lastAttemptTime;
        m_lastScanTime = lastScanTime;
        m_severity = severity;
        m_vulnPlugin = vulnPlugin;
    }

    @Id
    @SequenceGenerator(name="vulnerabilitySequence", sequenceName="vulnerabilityId")
    @GeneratedValue(generator="vulnerabilitySequence")
    @Column(name="vulnerabilityId")
    public Integer getVulnerabilityId() {
        return m_vulnerabilityId;
    }

    public void setVulnerabilityId(Integer vulnerabilityId) {
        m_vulnerabilityId = vulnerabilityId;
    }

    @ManyToOne
    @JoinColumn(name="nodeid")
    public OnmsNode getNode() {
        return m_node;
    }

    public void setNode(OnmsNode node) {
        m_node = node;
    }

//    /** 
//     *            @hibernate.property
//     *             column="ipaddr"
//     *             length="16"
//     *         
//     */
//    public OnmsIpInterface getIpInterface() {
//        return m_ipInterface;
//    }
//
//    public void setIpInterface(OnmsIpInterface ipInterface) {
//        m_ipInterface = ipInterface;
//    }

    
    //TODO: Add this column to create.sql, should remove node column, may
    //need trigger for refactoring
    @ManyToOne
    @JoinColumn(name="ifServiceId")
    public OnmsMonitoredService getMonitoredService() {
        return m_monitoredService;
    }

    public void setMonitoredService(OnmsMonitoredService monitoredService) {
        m_monitoredService = monitoredService;
    }

    
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="creationTime", nullable=false)
    public Date getCreationTime() {
        return m_creationTime;
    }

    public void setCreationTime(Date creationTime) {
        m_creationTime = creationTime;
    }

    
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="lastAttemptTime", nullable=false)
    public Date getLastAttemptTime() {
        return m_lastAttemptTime;
    }

    public void setLastAttemptTime(Date lastAttemptTime) {
        m_lastAttemptTime = lastAttemptTime;
    }

    
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="lastScanTime", nullable=false)
    public Date getLastScanTime() {
        return m_lastScanTime;
    }

    public void setLastScanTime(Date lastScanTime) {
        m_lastScanTime = lastScanTime;
    }

    
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="resolvedTime")
    public Date getResolvedTime() {
        return m_resolvedTime;
    }

    public void setResolvedTime(Date resolvedTime) {
        m_resolvedTime = resolvedTime;
    }

    
    @Column(name="severity")
    public Integer getSeverity() {
        return m_severity;
    }

    public void setSeverity(Integer severity) {
        m_severity = severity;
    }

    
    @ManyToOne
    @JoinColumn(name="pluginId", nullable=false)
    public OnmsVulnPlugin getVulnPlugin() {
        return m_vulnPlugin;
    }

    public void setVulnPlugin(OnmsVulnPlugin vulnPlugin) {
        m_vulnPlugin = vulnPlugin;
    }

    
    @Column(name="logMsg", length=256)
    public String getLogMsg() {
        return m_logMsg;
    }

    public void setLogMsg(String logMsg) {
        m_logMsg = logMsg;
    }


    @Column(name="descr", length=1024)
    public String getDescr() {
        return m_descr;
    }

    public void setDescr(String descr) {
        m_descr = descr;
    }

    
    @Column(name="port")
    public Integer getPort() {
        return m_port;
    }

    public void setPort(Integer port) {
        m_port = port;
    }


    @Column(name="protocol", length=32)
    public String getProtocol() {
        return m_protocol;
    }

    public void setProtocol(String protocol) {
        m_protocol = protocol;
    }


    @Column(name="cveEntry", length=14)
    public String getCveEntry() {
        return m_cveEntry;
    }

    public void setCveEntry(String cveEntry) {
        m_cveEntry = cveEntry;
    }

    public String toString() {
        return new ToStringCreator(this)
            .append("vulnerabilityId", getVulnerabilityId())
            .toString();
    }

	public void visit(EntityVisitor visitor) {
		// TODO Auto-generated method stub
		throw new RuntimeException("visitor method not implemented");
		
	}

}
