/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.xml.bind.InetAddressXmlAdapter;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.OnmsUserNotification;
import org.springframework.core.style.ToStringCreator;

@XmlRootElement(name="notification")
@Entity
@Table(name="notifications")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class OnmsNotification
implements Acknowledgeable,
Serializable {
    private static final long serialVersionUID = -1162549324168290004L;
    private Integer m_notifyId;
    private String m_textMsg;
    private String m_subject;
    private String m_numericMsg;
    private Date m_pageTime;
    private Date m_respondTime;
    private String m_answeredBy;
    private OnmsServiceType m_serviceType;
    private String m_queueId;
    private OnmsEvent m_event;
    private OnmsNode m_node;
    private Set<OnmsUserNotification> m_usersNotified = new HashSet<OnmsUserNotification>();
    private InetAddress m_ipAddress;
    private String m_notifConfigName;

    public OnmsNotification(Integer notifyId, String textMsg, String subject, String numericMsg, Date pageTime, Date respondTime, String answeredBy, InetAddress ipAddress, OnmsServiceType serviceType, String queueId, OnmsEvent event, OnmsNode node, Set<OnmsUserNotification> usersNotified, String notifConfigName) {
        this.m_notifyId = notifyId;
        this.m_textMsg = textMsg;
        this.m_subject = subject;
        this.m_numericMsg = numericMsg;
        this.m_pageTime = pageTime;
        this.m_respondTime = respondTime;
        this.m_answeredBy = answeredBy;
        this.m_ipAddress = ipAddress;
        this.m_serviceType = serviceType;
        this.m_queueId = queueId;
        this.m_event = event;
        this.m_node = node;
        this.m_usersNotified = usersNotified;
        this.m_notifConfigName = notifConfigName;
    }

    public OnmsNotification() {
    }

    public OnmsNotification(Integer notifyId, String textMsg, OnmsEvent event, OnmsNode node, Set<OnmsUserNotification> usersNotified) {
        this.m_notifyId = notifyId;
        this.m_textMsg = textMsg;
        this.m_event = event;
        this.m_node = node;
        this.m_usersNotified = usersNotified;
    }

    @Id
    @Column(nullable=false)
    @XmlAttribute(name="id")
    @SequenceGenerator(name="notifySequence", sequenceName="notifyNxtId")
    @GeneratedValue(generator="notifySequence")
    public Integer getNotifyId() {
        return this.m_notifyId;
    }

    public void setNotifyId(Integer notifyid) {
        this.m_notifyId = notifyid;
    }

    @XmlElement(name="textMessage")
    @Column(name="textMsg", length=4000, nullable=false)
    public String getTextMsg() {
        return this.m_textMsg;
    }

    public void setTextMsg(String textmsg) {
        this.m_textMsg = textmsg;
    }

    @XmlElement(name="subject")
    @Column(name="subject", length=256)
    public String getSubject() {
        return this.m_subject;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    @XmlElement(name="numericMessage")
    @Column(name="numericMsg", length=256)
    public String getNumericMsg() {
        return this.m_numericMsg;
    }

    public void setNumericMsg(String numericmsg) {
        this.m_numericMsg = numericmsg;
    }

    @XmlElement(name="pageTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="pageTime")
    public Date getPageTime() {
        return this.m_pageTime;
    }

    public void setPageTime(Date pagetime) {
        this.m_pageTime = pagetime;
    }

    @XmlElement(name="respondTime")
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="respondTime")
    public Date getRespondTime() {
        return this.m_respondTime;
    }

    public void setRespondTime(Date respondtime) {
        this.m_respondTime = respondtime;
    }

    @XmlElement(name="answeredBy")
    @Column(name="answeredBy", length=256)
    public String getAnsweredBy() {
        return this.m_answeredBy;
    }

    public void setAnsweredBy(String answeredby) {
        this.m_answeredBy = answeredby;
    }

    @Column(name="interfaceId")
    @XmlElement(name="ipAddress")
    @Type(type="org.opennms.netmgt.model.InetAddressUserType")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    public InetAddress getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @ManyToOne
    @JoinColumn(name="serviceId")
    public OnmsServiceType getServiceType() {
        return this.m_serviceType;
    }

    public void setServiceType(OnmsServiceType serviceType) {
        this.m_serviceType = serviceType;
    }

    @Column(name="queueId", length=256)
    public String getQueueId() {
        return this.m_queueId;
    }

    public void setQueueId(String queueid) {
        this.m_queueId = queueid;
    }

    @XmlTransient
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="eventId", nullable=false)
    public OnmsEvent getEvent() {
        return this.m_event;
    }

    public void setEvent(OnmsEvent event) {
        this.m_event = event;
    }

    @XmlElement(name="uei")
    @Column(name="eventUEI")
    public String getEventUei() {
        return this.m_event.getEventUei();
    }

    public void setEventUei(String eventUei) {
    }

    @Transient
    @XmlAttribute(name="severity")
    public String getSeverityLabel() {
        return this.m_event.getSeverityLabel();
    }

    @Override
    @XmlTransient
    @ManyToOne
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    @Transient
    @XmlElement(name="nodeId", required=false)
    public Integer getNodeId() {
        if (this.m_node == null) {
            return null;
        }
        return this.m_node.getId();
    }

    @Transient
    @XmlElement(name="nodeLabel", required=false)
    public String getNodeLabel() {
        if (this.m_node == null) {
            return null;
        }
        return this.m_node.getLabel();
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlElement(name="destination")
    @XmlElementWrapper(name="destinations")
    @OneToMany(mappedBy="notification", fetch=FetchType.LAZY)
    public Set<OnmsUserNotification> getUsersNotified() {
        return this.m_usersNotified;
    }

    public void setUsersNotified(Set<OnmsUserNotification> usersnotifieds) {
        this.m_usersNotified = usersnotifieds;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("notifyid", (Object)this.getNotifyId()).toString();
    }

    public String getNotifConfigName() {
        return this.m_notifConfigName;
    }

    @XmlElement(name="notificationName")
    @Column(name="notifConfigName", length=63)
    public void setNotifConfigName(String notifConfigName) {
        this.m_notifConfigName = notifConfigName;
    }

    @Override
    public void acknowledge(String ackUser) {
        if (this.m_answeredBy == null || this.m_respondTime == null) {
            this.m_answeredBy = ackUser;
            this.m_respondTime = Calendar.getInstance().getTime();
        }
    }

    @Override
    @Transient
    public AckType getType() {
        return AckType.NOTIFICATION;
    }

    @Override
    @Transient
    public Integer getAckId() {
        return this.m_notifyId;
    }

    @Override
    @Transient
    public String getAckUser() {
        return this.m_answeredBy;
    }

    @Override
    @Transient
    public Date getAckTime() {
        return this.m_respondTime;
    }

    @Override
    public void clear(String ackUser) {
        this.m_respondTime = Calendar.getInstance().getTime();
        this.m_answeredBy = ackUser;
    }

    @Override
    public void escalate(String ackUser) {
    }

    @Override
    public void unacknowledge(String ackUser) {
        this.m_respondTime = null;
        this.m_answeredBy = null;
    }
}

