/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="link")
@Entity
@Table(name="datalinkinterface")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DataLinkInterface
implements Serializable,
Comparable<DataLinkInterface> {
    private static final long serialVersionUID = -3336726327359373609L;
    private Integer m_id;
    private OnmsNode m_node;
    @Column(name="ifindex", nullable=false)
    private Integer m_ifIndex;
    @Column(name="nodeparentid", nullable=false)
    private Integer m_nodeParentId;
    @Column(name="parentifindex", nullable=false)
    private Integer m_parentIfIndex;
    @Column(name="status", length=1, nullable=false)
    private String m_status;
    @Column(name="linktypeid", nullable=true)
    private Integer m_linkTypeId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lastpolltime", nullable=false)
    private Date m_lastPollTime;
    @Column(name="source", nullable=false)
    private String m_source = "linkd";
    @Transient
    private Integer m_nodeId = null;

    public DataLinkInterface() {
    }

    public DataLinkInterface(OnmsNode node, int ifIndex, int nodeParentId, int parentIfIndex, String status, Date lastPollTime) {
        this.m_node = node;
        this.m_ifIndex = ifIndex;
        this.m_nodeParentId = nodeParentId;
        this.m_parentIfIndex = parentIfIndex;
        this.m_status = status;
        this.m_lastPollTime = lastPollTime;
        this.m_linkTypeId = -1;
    }

    @XmlTransient
    @Id
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(int id) {
        this.m_id = id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getDataLinkInterfaceId() {
        return this.getId().toString();
    }

    public void setDataLinkInterfaceId(String id) {
        this.m_id = Integer.valueOf(id);
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlTransient
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Transient
    @XmlElement(name="nodeId")
    public Integer getNodeId() {
        return this.m_node == null ? this.m_nodeId : this.m_node.getId();
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    @XmlElement(name="ifIndex")
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @XmlElement(name="nodeParentId")
    public Integer getNodeParentId() {
        return this.m_nodeParentId;
    }

    public void setNodeParentId(Integer nodeParentId) {
        this.m_nodeParentId = nodeParentId;
    }

    @XmlElement(name="parentIfIndex")
    public Integer getParentIfIndex() {
        return this.m_parentIfIndex;
    }

    public void setParentIfIndex(Integer parentIfIndex) {
        this.m_parentIfIndex = parentIfIndex;
    }

    @XmlAttribute(name="status")
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @XmlElement(name="linkTypeId")
    public Integer getLinkTypeId() {
        return this.m_linkTypeId;
    }

    public void setLinkTypeId(Integer linkTypeId) {
        this.m_linkTypeId = linkTypeId;
    }

    @XmlElement(name="lastPollTime")
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @XmlAttribute(name="source")
    public String getSource() {
        return this.m_source;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    @Override
    public int compareTo(DataLinkInterface o) {
        return new CompareToBuilder().append((Object)this.getId(), (Object)o.getId()).append((Object)this.getNode(), (Object)o.getNode()).append((Object)this.getIfIndex(), (Object)o.getIfIndex()).append((Object)this.getSource(), (Object)o.getSource()).append((Object)this.getNodeParentId(), (Object)o.getNodeParentId()).append((Object)this.getParentIfIndex(), (Object)o.getParentIfIndex()).append((Object)this.getStatus(), (Object)o.getStatus()).append((Object)this.getLastPollTime(), (Object)o.getLastPollTime()).append((Object)this.getLinkTypeId(), (Object)o.getLinkTypeId()).toComparison();
    }
}

