/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="stpInterface")
@Entity
@Table(name="stpInterface", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "bridgePort", "stpVlan"})})
public class OnmsStpInterface {
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_bridgePort;
    private Integer m_ifIndex = -1;
    private Integer m_stpPortState;
    private Integer m_stpPortPathCost;
    private String m_stpPortDesignatedRoot;
    private Integer m_stpPortDesignatedCost;
    private String m_stpPortDesignatedBridge;
    private String m_stpPortDesignatedPort;
    private Character m_status;
    private Date m_lastPollTime;
    private Integer m_vlan;

    public OnmsStpInterface() {
    }

    public OnmsStpInterface(Integer bridgePort, Integer vlanIndex) {
        this.m_bridgePort = bridgePort;
        this.m_vlan = vlanIndex;
    }

    public OnmsStpInterface(OnmsNode node, Integer bridgePort, Integer vlanIndex) {
        this.m_node = node;
        this.m_bridgePort = bridgePort;
        this.m_vlan = vlanIndex;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Integer getIfIndex() {
        return this.m_ifIndex;
    }

    public void setIfIndex(Integer ifIndex) {
        this.m_ifIndex = ifIndex;
    }

    @XmlElement
    @Column
    public Integer getStpPortState() {
        return this.m_stpPortState;
    }

    public void setStpPortState(Integer stpPortState) {
        this.m_stpPortState = stpPortState;
    }

    @XmlElement
    @Column
    public Integer getStpPortPathCost() {
        return this.m_stpPortPathCost;
    }

    public void setStpPortPathCost(Integer stpPortPathCost) {
        this.m_stpPortPathCost = stpPortPathCost;
    }

    @XmlElement
    @Column(length=16)
    public String getStpPortDesignatedRoot() {
        return this.m_stpPortDesignatedRoot;
    }

    public void setStpPortDesignatedRoot(String stpPortDesignatedRoot) {
        this.m_stpPortDesignatedRoot = stpPortDesignatedRoot;
    }

    @XmlElement
    @Column
    public Integer getStpPortDesignatedCost() {
        return this.m_stpPortDesignatedCost;
    }

    public void setStpPortDesignatedCost(Integer stpPortDesignatedCost) {
        this.m_stpPortDesignatedCost = stpPortDesignatedCost;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Character getStatus() {
        return this.m_status;
    }

    public void setStatus(Character status) {
        this.m_status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @XmlElement
    @Column(nullable=false)
    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    @XmlElement
    @Column(length=16)
    public String getStpPortDesignatedBridge() {
        return this.m_stpPortDesignatedBridge;
    }

    public void setStpPortDesignatedBridge(String stpPortDesignatedBridge) {
        this.m_stpPortDesignatedBridge = stpPortDesignatedBridge;
    }

    @XmlElement
    @Column(length=4)
    public String getStpPortDesignatedPort() {
        return this.m_stpPortDesignatedPort;
    }

    public void setStpPortDesignatedPort(String stpPortDesignatedPort) {
        this.m_stpPortDesignatedPort = stpPortDesignatedPort;
    }

    @XmlElement(name="stpVlan")
    @Column(name="stpVlan", nullable=false)
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }
}

