/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Forward;
import org.opennms.netmgt.xml.event.Operaction;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.netmgt.xml.event.Script;
import org.opennms.netmgt.xml.event.Snmp;
import org.opennms.netmgt.xml.event.Value;

public abstract class EventUtils {
    public static Event createNodeAddedEvent(String source, int nodeId, String nodeLabel, String labelSource) {
        EventUtils.debug("CreateNodeAddedEvent: nodedId: %d", nodeId);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeAdded", source);
        bldr.setNodeid(nodeId);
        bldr.addParam("nodelabel", nodeLabel);
        bldr.addParam("nodelabelsource", labelSource);
        return bldr.getEvent();
    }

    public static Event createNodeGainedInterfaceEvent(String source, int nodeId, InetAddress ifaddr) {
        EventUtils.debug("createNodeGainedInterfaceEvent:  %d / %s", nodeId, InetAddressUtils.str((InetAddress)ifaddr));
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedInterface", source);
        bldr.setNodeid(nodeId);
        bldr.setInterface(ifaddr);
        bldr.addParam("iphostname", ifaddr.getHostName());
        return bldr.getEvent();
    }

    public static Event createNodeGainedServiceEvent(String source, int nodeId, InetAddress ifaddr, String service, String nodeLabel, String labelSource, String sysName, String sysDescr) {
        EventUtils.debug("createAndSendNodeGainedServiceEvent:  nodeId/interface/service  %d/%s/%s", nodeId, InetAddressUtils.str((InetAddress)ifaddr), service);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", source);
        bldr.setNodeid(nodeId);
        bldr.setInterface(ifaddr);
        bldr.setService(service);
        bldr.setParam("iphostname", ifaddr.getHostName());
        bldr.setParam("nodelabel", nodeLabel);
        bldr.setParam("nodelabelsource", labelSource);
        if (sysName != null) {
            bldr.setParam("nodesysname", sysName);
        }
        if (sysDescr != null) {
            bldr.setParam("nodesysdescription", sysDescr);
        }
        return bldr.getEvent();
    }

    public static Event createNodeDeletedEvent(String source, int nodeId, String hostName, String nodeLabel) {
        EventUtils.debug("createNodeDeletedEvent for nodeid:  %d", nodeId);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeDeleted", source);
        bldr.setNodeid(nodeId);
        bldr.setHost(hostName);
        if (nodeLabel != null) {
            bldr.addParam("nodelabel", nodeLabel);
        }
        return bldr.getEvent();
    }

    public static Event createInterfaceDeletedEvent(String source, int nodeId, InetAddress addr) {
        EventUtils.debug("createInterfaceDeletedEvent for nodeid/ipaddr:  %d/%s", nodeId, InetAddressUtils.str((InetAddress)addr));
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/interfaceDeleted", source);
        bldr.setNodeid(nodeId);
        bldr.setInterface(addr);
        return bldr.getEvent();
    }

    public static Event createServiceDeletedEvent(String source, int nodeId, InetAddress addr, String service) {
        EventUtils.debug("createServiceDeletedEvent for nodeid/ipaddr/service:  %d/%s", nodeId, InetAddressUtils.str((InetAddress)addr), service);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/serviceDeleted", source);
        bldr.setNodeid(nodeId);
        bldr.setInterface(addr);
        bldr.setService(service);
        return bldr.getEvent();
    }

    public static long getLongParm(Event e, String parmName, long defaultValue) {
        String longVal = EventUtils.getParm(e, parmName);
        if (longVal == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(longVal);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static int getIntParm(Event e, String parmName, int defaultValue) {
        String intVal = EventUtils.getParm(e, parmName);
        if (intVal == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(intVal);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    public static String getParm(Event e, String parmName, String defaultValue) {
        if (e.getParmCollection().size() < 1) {
            return defaultValue;
        }
        for (Parm parm : e.getParmCollection()) {
            if (!parmName.equals(parm.getParmName())) continue;
            if (parm.getValue() != null && parm.getValue().getContent() != null) {
                return parm.getValue().getContent();
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static String getParm(Event e, String parmName) {
        return EventUtils.getParm(e, parmName, null);
    }

    private static void debug(String format, Object ... args) {
        ThreadCategory log = ThreadCategory.getInstance(EventUtils.class);
        if (log.isDebugEnabled()) {
            log.debug(String.format(format, args));
        }
    }

    public static Event createNodeUpdatedEvent(String source, Integer nodeId, String nodeLabel, String labelSource) {
        EventUtils.debug("CreateNodeUpdatedEvent: nodedId: %d", nodeId);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeUpdated", source);
        bldr.setNodeid(nodeId.intValue());
        bldr.addParam("nodelabel", nodeLabel);
        bldr.addParam("nodelabelsource", labelSource);
        return bldr.getEvent();
    }

    public static String toString(Event event) {
        Iterator<Object> i;
        StringBuffer b = new StringBuffer("Event: ");
        if (event.getAutoacknowledge() != null) {
            b.append(" Autoacknowledge: " + event.getAutoacknowledge() + "\n");
        }
        if (event.getAutoactionCount() > 0) {
            b.append(" Autoactions:");
            i = event.getAutoactionCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + i.next().toString());
            }
            b.append("\n");
        }
        if (event.getCreationTime() != null) {
            b.append(" CreationTime: " + event.getCreationTime() + "\n");
        }
        b.append(" Dbid: " + event.getDbid() + "\n");
        if (event.getDescr() != null) {
            b.append(" Descr: " + event.getDescr() + "\n");
        }
        if (event.getDistPoller() != null) {
            b.append(" DistPoller: " + event.getDistPoller() + "\n");
        }
        if (event.getForwardCount() > 0) {
            b.append(" Forwards:");
            i = event.getForwardCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Forward)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getHost() != null) {
            b.append(" Host: " + event.getHost() + "\n");
        }
        if (event.getInterface() != null) {
            b.append(" Interface: " + event.getInterface() + "\n");
        }
        if (event.getLoggroupCount() > 0) {
            b.append(" Loggroup:");
            i = event.getLoggroupCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + (String)i.next());
            }
            b.append("\n");
        }
        if (event.getLogmsg() != null) {
            b.append(" Logmsg: " + event.getLogmsg() + "\n");
        }
        if (event.getMask() != null) {
            b.append(" Mask: " + event.getMask() + "\n");
        }
        if (event.getMasterStation() != null) {
            b.append(" MasterStation: " + event.getMasterStation() + "\n");
        }
        if (event.getMouseovertext() != null) {
            b.append(" Mouseovertext: " + event.getMouseovertext() + "\n");
        }
        b.append(" Nodeid: " + event.getNodeid() + "\n");
        if (event.getOperactionCount() > 0) {
            b.append(" Operaction:");
            i = event.getOperactionCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Operaction)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getOperinstruct() != null) {
            b.append(" Operinstruct: " + event.getOperinstruct() + "\n");
        }
        if (event.getParmCollection().size() > 0) {
            b.append(" Parms: " + EventUtils.toString(event.getParmCollection()) + "\n");
        }
        if (event.getScriptCount() > 0) {
            b.append(" Script:");
            i = event.getScriptCollection().iterator();
            while (i.hasNext()) {
                b.append(" " + ((Script)i.next()).toString());
            }
            b.append("\n");
        }
        if (event.getService() != null) {
            b.append(" Service: " + event.getService() + "\n");
        }
        if (event.getSeverity() != null) {
            b.append(" Severity: " + event.getSeverity() + "\n");
        }
        if (event.getSnmp() != null) {
            b.append(" Snmp: " + EventUtils.toString(event.getSnmp()) + "\n");
        }
        if (event.getSnmphost() != null) {
            b.append(" Snmphost: " + event.getSnmphost() + "\n");
        }
        if (event.getSource() != null) {
            b.append(" Source: " + event.getSource() + "\n");
        }
        if (event.getTime() != null) {
            b.append(" Time: " + event.getTime() + "\n");
        }
        if (event.getTticket() != null) {
            b.append(" Tticket: " + event.getTticket() + "\n");
        }
        if (event.getUei() != null) {
            b.append(" Uei: " + event.getUei() + "\n");
        }
        if (event.getUuid() != null) {
            b.append(" Uuid: " + event.getUuid() + "\n");
        }
        b.append("End Event\n");
        return b.toString();
    }

    public static String toString(Collection<Parm> parms) {
        if (parms.size() == 0) {
            return "Parms: (none)\n";
        }
        StringBuffer b = new StringBuffer();
        b.append("Parms:\n");
        for (Parm p : parms) {
            b.append(" ");
            b.append(p.getParmName());
            b.append(" = ");
            b.append(EventUtils.toString(p.getValue()));
            b.append("\n");
        }
        b.append("End Parms\n");
        return b.toString();
    }

    public static String toString(Value value) {
        return value.getType() + "(" + value.getEncoding() + "): " + value.getContent();
    }

    public static String toString(Snmp snmp) {
        StringBuffer b = new StringBuffer("Snmp: ");
        if (snmp.getVersion() != null) {
            b.append("Version: " + snmp.getVersion() + "\n");
        }
        b.append("TimeStamp: " + new Date(snmp.getTimeStamp()) + "\n");
        if (snmp.getCommunity() != null) {
            b.append("Community: " + snmp.getCommunity() + "\n");
        }
        b.append("Generic: " + snmp.getGeneric() + "\n");
        b.append("Specific: " + snmp.getSpecific() + "\n");
        if (snmp.getId() != null) {
            b.append("Id: " + snmp.getId() + "\n");
        }
        if (snmp.getIdtext() != null) {
            b.append("Idtext: " + snmp.getIdtext() + "\n");
        }
        b.append("End Snmp\n");
        return b.toString();
    }
}

