/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.alarm;

import java.util.Date;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.opennms.core.utils.FuzzyDateFormatter;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmSummary
implements Comparable<AlarmSummary> {
    private final int nodeId;
    private final String nodeLabel;
    private final Date minLastEventDate;
    private final OnmsSeverity maxSeverity;
    private final long alarmCount;

    public AlarmSummary(Integer nodeId, String nodeLabel, Date minLastEventDate, OnmsSeverity maxSeverity, Long alarmCount) {
        this.nodeId = nodeId;
        this.nodeLabel = nodeLabel == null ? String.valueOf(nodeId) : nodeLabel;
        this.minLastEventDate = minLastEventDate;
        this.maxSeverity = maxSeverity;
        this.alarmCount = alarmCount;
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getNodeLabel() {
        return this.nodeLabel;
    }

    public Date getMinLastEventDate() {
        return this.minLastEventDate;
    }

    public long getAlarmCount() {
        return this.alarmCount;
    }

    public OnmsSeverity getMaxSeverity() {
        return this.maxSeverity;
    }

    public String getFuzzyTimeDown() {
        return this.minLastEventDate == null ? "N/A" : FuzzyDateFormatter.calculateDifference((Date)this.minLastEventDate, (Date)new Date());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[AlarmSummary: ");
        buffer.append(this.nodeId);
        buffer.append(":");
        buffer.append(this.nodeLabel);
        buffer.append(" has ");
        buffer.append(this.alarmCount);
        buffer.append(" alarms since ");
        buffer.append(this.minLastEventDate);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public int compareTo(AlarmSummary that) {
        return new CompareToBuilder().append((Object)this.getMinLastEventDate(), (Object)that.getMinLastEventDate()).append((Object)this.getNodeLabel(), (Object)that.getNodeLabel()).toComparison();
    }
}

