/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="stpNode")
@Entity
@Table(name="stpNode", uniqueConstraints={@UniqueConstraint(columnNames={"nodeId", "baseVlan"})})
public class OnmsStpNode {
    private Integer m_id;
    private OnmsNode m_node;
    private String m_baseBridgeAddress;
    private Integer m_baseNumPorts;
    private Integer m_baseType;
    private Integer m_stpProtocolSpecification;
    private Integer m_stpPriority;
    private String m_stpDesignatedRoot;
    private Integer m_stpRootCost;
    private Integer m_stpRootPort;
    private Character m_status;
    private Date m_lastPollTime;
    private Integer m_baseVlan;
    private String m_baseVlanName;

    public OnmsStpNode() {
    }

    public OnmsStpNode(OnmsNode node, Integer vlanIndex) {
        this.m_node = node;
        this.m_baseVlan = vlanIndex;
    }

    @Id
    @Column(nullable=false)
    @XmlTransient
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    @XmlID
    @XmlAttribute(name="id")
    @Transient
    public String getInterfaceId() {
        return this.getId().toString();
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    @XmlElement(name="nodeId")
    @XmlIDREF
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @XmlElement
    @Column(length=12, nullable=false)
    public String getBaseBridgeAddress() {
        return this.m_baseBridgeAddress;
    }

    public void setBaseBridgeAddress(String baseBridgeAddress) {
        this.m_baseBridgeAddress = baseBridgeAddress;
    }

    @XmlElement
    @Column
    public Integer getBaseNumPorts() {
        return this.m_baseNumPorts;
    }

    public void setBaseNumPorts(Integer baseNumPorts) {
        this.m_baseNumPorts = baseNumPorts;
    }

    @XmlElement
    @Column
    public Integer getBaseType() {
        return this.m_baseType;
    }

    public void setBaseType(Integer baseType) {
        this.m_baseType = baseType;
    }

    @XmlElement
    @Column
    public Integer getStpProtocolSpecification() {
        return this.m_stpProtocolSpecification;
    }

    public void setStpProtocolSpecification(Integer stpProtocolSpecification) {
        this.m_stpProtocolSpecification = stpProtocolSpecification;
    }

    @XmlElement
    @Column
    public Integer getStpPriority() {
        return this.m_stpPriority;
    }

    public void setStpPriority(Integer stpPriority) {
        this.m_stpPriority = stpPriority;
    }

    @XmlElement
    @Column(length=16)
    public String getStpDesignatedRoot() {
        return this.m_stpDesignatedRoot;
    }

    public void setStpDesignatedRoot(String stpDesignatedRoot) {
        this.m_stpDesignatedRoot = stpDesignatedRoot;
    }

    @XmlElement
    @Column
    public Integer getStpRootCost() {
        return this.m_stpRootCost;
    }

    public void setStpRootCost(Integer stpRootCost) {
        this.m_stpRootCost = stpRootCost;
    }

    @XmlElement
    @Column
    public Integer getStpRootPort() {
        return this.m_stpRootPort;
    }

    public void setStpRootPort(Integer stpRootPort) {
        this.m_stpRootPort = stpRootPort;
    }

    @XmlAttribute
    @Column(nullable=false)
    public Character getStatus() {
        return this.m_status;
    }

    public void setStatus(Character statusActive) {
        this.m_status = statusActive;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    @XmlElement
    public Date getLastPollTime() {
        return this.m_lastPollTime;
    }

    public void setLastPollTime(Date lastPollTime) {
        this.m_lastPollTime = lastPollTime;
    }

    @XmlElement
    @Column(nullable=false)
    public Integer getBaseVlan() {
        return this.m_baseVlan;
    }

    public void setBaseVlan(Integer baseVlan) {
        this.m_baseVlan = baseVlan;
    }

    @XmlElement
    @Column(length=32)
    public String getBaseVlanName() {
        return this.m_baseVlanName;
    }

    public void setBaseVlanName(String baseVlanName) {
        this.m_baseVlanName = baseVlanName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.m_id).append("node", (Object)this.m_node).append("baseBridgeAddress", (Object)this.m_baseBridgeAddress).append("baseNumPorts", (Object)this.m_baseNumPorts).append("baseType", (Object)this.m_baseType).append("stpProtocolSpecification", (Object)this.m_stpProtocolSpecification).append("stpPriority", (Object)this.m_stpPriority).append("stpDesignatedRoot", (Object)this.m_stpDesignatedRoot).append("stpRootCost", (Object)this.m_stpRootCost).append("stpRootPort", (Object)this.m_stpRootPort).append("status", (Object)this.m_status).append("lastPollTime", (Object)this.m_lastPollTime).append("baseVlan", (Object)this.m_baseVlan).append("baseVlanName", (Object)this.m_baseVlanName).toString();
    }
}

