/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.model.OnmsNotification;
import org.springframework.core.style.ToStringCreator;

@Entity
@Table(name="usersNotified")
public class OnmsUserNotification
implements Serializable {
    private static final long serialVersionUID = -1750912427062821742L;
    private Integer m_id;
    private String m_userId;
    private Date m_notifyTime;
    private String m_media;
    private String m_contactInfo;
    private String m_autoNotify;
    private OnmsNotification m_notification;

    public OnmsUserNotification(String userId, Date notifyTime, String media, String contactInfo, String autoNotify, OnmsNotification notification, Integer id) {
        this.m_userId = userId;
        this.m_notifyTime = notifyTime;
        this.m_media = media;
        this.m_contactInfo = contactInfo;
        this.m_autoNotify = autoNotify;
        this.m_notification = notification;
        this.m_id = id;
    }

    public OnmsUserNotification() {
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="userNotificationSequence", sequenceName="userNotifNxtId")
    @GeneratedValue(generator="userNotificationSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @Column(name="userId", length=256)
    public String getUserId() {
        return this.m_userId;
    }

    public void setUserId(String userId) {
        this.m_userId = userId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="notifyTime")
    public Date getNotifyTime() {
        return this.m_notifyTime;
    }

    public void setNotifyTime(Date notifyTime) {
        this.m_notifyTime = notifyTime;
    }

    @Column(name="media", length=32)
    public String getMedia() {
        return this.m_media;
    }

    public void setMedia(String media) {
        this.m_media = media;
    }

    @Column(name="contactInfo", length=64)
    public String getContactInfo() {
        return this.m_contactInfo;
    }

    public void setContactInfo(String contactInfo) {
        this.m_contactInfo = contactInfo;
    }

    @Column(name="autoNotify", length=1)
    public String getAutoNotify() {
        return this.m_autoNotify;
    }

    public void setAutoNotify(String autoNotify) {
        this.m_autoNotify = autoNotify;
    }

    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="notifyId")
    public OnmsNotification getNotification() {
        return this.m_notification;
    }

    public void setNotification(OnmsNotification notification) {
        this.m_notification = notification;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("userId", (Object)this.getUserId()).append("notifyTime", (Object)this.getNotifyTime()).append("media", (Object)this.getMedia()).append("contactInfo", (Object)this.getContactInfo()).append("autoNotify", (Object)this.getAutoNotify()).append("id", (Object)this.getId()).toString();
    }
}

