/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.opennms.netmgt.provision.server.exchange.LineConversation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServerHandler
extends IoHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleServerHandler.class);
    private LineConversation m_conversation;

    public SimpleServerHandler(LineConversation conversation) {
        this.m_conversation = conversation;
    }

    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        LOG.warn("An error was caught in session {}", (Object)session, (Object)cause);
    }

    public void sessionOpened(IoSession session) throws Exception {
        LOG.info("Session opened");
        if (this.m_conversation != null && this.m_conversation.hasBanner()) {
            LOG.info("Sending Banner: {} \n", (Object)this.m_conversation.getBanner());
            session.write((Object)this.m_conversation.getBanner());
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        LOG.info("Server received: {}\n", (Object)message.toString().trim());
        String str = message.toString();
        if (str.trim().equalsIgnoreCase(this.m_conversation.getExpectedClose())) {
            if (this.m_conversation.getExpectedCloseResponse() != null) {
                session.write((Object)this.m_conversation.getExpectedCloseResponse());
            }
            if (!session.close(false).await(500L)) {
                LOG.warn("Conversation did not complete promptly in 500ms");
            }
            return;
        }
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        LOG.info("IDLE {}", (Object)session.getIdleCount(status));
    }
}

