/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.provision.server.SimpleServerRunnable;
import org.opennms.netmgt.provision.server.exchange.Exchange;
import org.opennms.netmgt.provision.server.exchange.RequestHandler;
import org.opennms.netmgt.provision.server.exchange.SimpleConversationEndPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServer
extends SimpleConversationEndPoint {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleServer.class);
    private ServerSocket m_serverSocket = null;
    private Thread m_serverThread = null;
    private int m_threadSleepLength = 0;
    private Socket m_socket;
    private String m_banner;
    private int m_bannerDelay = 0;
    protected volatile boolean m_stopped = false;
    private volatile SimpleServerRunnable m_runnable;

    public void setBanner(String banner) {
        this.m_banner = banner;
    }

    public String getBanner() {
        return this.m_banner;
    }

    public void setBannerDelay(int delay) {
        this.m_bannerDelay = delay;
    }

    public InetAddress getInetAddress() {
        return this.getServerSocket().getInetAddress();
    }

    public int getLocalPort() {
        return this.getServerSocket().getLocalPort();
    }

    public void setThreadSleepLength(int timeout) {
        this.m_threadSleepLength = timeout;
    }

    public int getThreadSleepLength() {
        return this.m_threadSleepLength;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setServerSocket(new ServerSocket());
        this.getServerSocket().bind(null);
        this.onInit();
    }

    protected void onInit() {
    }

    public void startServer() throws IOException {
        this.m_runnable = this.getRunnable();
        this.setServerThread(new Thread((Runnable)this.m_runnable, this.getClass().getSimpleName()));
        this.getServerThread().setDaemon(true);
        this.getServerThread().start();
        try {
            if (this.m_runnable != null) {
                this.m_runnable.awaitStartup();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Interrupted while starting up.", (Throwable)e);
        }
    }

    public void stopServer() throws IOException {
        if (!this.m_stopped) {
            this.m_stopped = true;
            Thread t = this.getServerThread();
            this.setServerThread(null);
            IOUtils.closeQuietly((Socket)this.getSocket());
            IOUtils.closeQuietly((ServerSocket)this.getServerSocket());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (t != null && t.isAlive()) {
                t.interrupt();
            }
            try {
                if (this.m_runnable != null) {
                    this.m_runnable.awaitShutdown();
                }
            }
            catch (InterruptedException e) {
                LOG.debug("Interrupted while shutting down.", (Throwable)e);
            }
        }
    }

    public void dispose() {
    }

    protected SimpleServerRunnable getRunnable() throws IOException {
        return new SimpleServerRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                OutputStream out = null;
                InputStreamReader isr = null;
                BufferedReader in = null;
                try {
                    if (SimpleServer.this.getTimeout() > 0) {
                        SimpleServer.this.getServerSocket().setSoTimeout(SimpleServer.this.getTimeout());
                    }
                    this.ready();
                    while (!SimpleServer.this.m_stopped && SimpleServer.this.getServerThread() != null) {
                        long startTime = 0L;
                        try {
                            SimpleServer.this.setSocket(SimpleServer.this.getServerSocket().accept());
                            if (SimpleServer.this.getTimeout() > 0) {
                                SimpleServer.this.getSocket().setSoTimeout(SimpleServer.this.getTimeout());
                            }
                            out = SimpleServer.this.getSocket().getOutputStream();
                            startTime = System.currentTimeMillis();
                            if (SimpleServer.this.m_threadSleepLength > 0) {
                                Thread.sleep(SimpleServer.this.m_threadSleepLength);
                            }
                            if (SimpleServer.this.getBanner() != null) {
                                SimpleServer.this.sendBanner(out);
                            }
                            isr = new InputStreamReader(SimpleServer.this.getSocket().getInputStream());
                            in = new BufferedReader(isr);
                            SimpleServer.this.attemptConversation(in, out);
                        }
                        catch (Throwable throwable) {
                            long sleepMore = startTime + (long)SimpleServer.this.getTimeout() - System.currentTimeMillis();
                            if (sleepMore > 0L) {
                                try {
                                    Thread.sleep(sleepMore);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            IOUtils.closeQuietly(in);
                            IOUtils.closeQuietly(isr);
                            IOUtils.closeQuietly((OutputStream)out);
                            IOUtils.closeQuietly((Socket)SimpleServer.this.getSocket());
                            throw throwable;
                            return;
                        }
                        long sleepMore = startTime + (long)SimpleServer.this.getTimeout() - System.currentTimeMillis();
                        if (sleepMore > 0L) {
                            try {
                                Thread.sleep(sleepMore);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        IOUtils.closeQuietly((Reader)in);
                        IOUtils.closeQuietly((Reader)isr);
                        IOUtils.closeQuietly((OutputStream)out);
                        IOUtils.closeQuietly((Socket)SimpleServer.this.getSocket());
                    }
                }
                catch (InterruptedException e) {
                    if (SimpleServer.this.m_stopped) {
                        LOG.debug("interrupted, shutting down", (Throwable)e);
                        return;
                    } else {
                        LOG.info("interrupted while listening", (Throwable)e);
                    }
                    return;
                }
                catch (Exception e) {
                    if (SimpleServer.this.m_stopped) {
                        LOG.trace("error during conversation", (Throwable)e);
                        return;
                    } else {
                        LOG.info("error during conversation", (Throwable)e);
                    }
                    return;
                }
                finally {
                    this.finished();
                    try {
                        SimpleServer.this.stopServer();
                    }
                    catch (Exception e) {
                        LOG.info("error while stopping server", (Throwable)e);
                    }
                }
            }
        };
    }

    protected void sendBanner(OutputStream out) throws IOException {
        byte[] bannerBytes = this.getBanner().getBytes();
        if (this.m_bannerDelay > 0) {
            int delayPerByte = (int)Math.ceil((float)this.m_bannerDelay / (float)bannerBytes.length);
            System.out.println("DELAY PER BYTE: " + delayPerByte);
            for (byte bannerByte : bannerBytes) {
                out.write(bannerByte);
                try {
                    Thread.sleep(delayPerByte);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } else {
            out.write(bannerBytes);
        }
        out.write("\r\n".getBytes());
    }

    protected boolean attemptConversation(BufferedReader in, OutputStream out) throws Exception {
        this.m_conversation.attemptServerConversation(in, out);
        return true;
    }

    protected void addErrorHandler(RequestHandler requestHandler) {
        this.m_conversation.addErrorExchange(new ServerErrorExchange(requestHandler));
    }

    protected RequestHandler errorString(final String error) {
        return new RequestHandler(){

            @Override
            public void doRequest(OutputStream out) throws IOException {
                out.write(String.format("%s\r\n", error).getBytes());
            }
        };
    }

    protected RequestHandler shutdownServer(final String response) {
        return new RequestHandler(){

            @Override
            public void doRequest(OutputStream out) throws IOException {
                out.write(String.format("%s\r\n", response).getBytes());
                try {
                    SimpleServer.this.stopServer();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.m_serverSocket = serverSocket;
    }

    public ServerSocket getServerSocket() {
        return this.m_serverSocket;
    }

    public void setSocket(Socket socket) {
        this.m_socket = socket;
    }

    public Socket getSocket() {
        return this.m_socket;
    }

    protected void setServerThread(Thread serverThread) {
        this.m_serverThread = serverThread;
    }

    protected Thread getServerThread() {
        return this.m_serverThread;
    }

    public static class ServerErrorExchange
    implements Exchange {
        protected RequestHandler m_errorRequest;

        public ServerErrorExchange(RequestHandler requestHandler) {
            this.m_errorRequest = requestHandler;
        }

        @Override
        public boolean matchResponseByString(String response) {
            return false;
        }

        @Override
        public boolean processResponse(BufferedReader in) throws IOException {
            return false;
        }

        @Override
        public boolean sendRequest(OutputStream out) throws IOException {
            this.m_errorRequest.doRequest(out);
            return false;
        }
    }
}

