/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.commons.io.IOUtils;
import org.opennms.netmgt.provision.server.SimpleServer;
import org.opennms.netmgt.provision.server.SimpleServerRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLServer
extends SimpleServer {
    private static final Logger LOG = LoggerFactory.getLogger(SSLServer.class);
    public static final int DEFAULT_TESTING_PORT = 7070;
    public static final String DEFAULT_PASSWORD = "123456";
    public static final String DEFAULT_PATH_TO_KEY_STORE = "src/main/resources/org/opennms/netmgt/provision/server/mySrvKeystore";
    public static final String DEFAULT_KEY_MANAGER_ALGORITHM = "SunX509";
    public static final String DEFAULT_KEY_MANAGER_PROVIDER = "SunJSSE";
    public static final String DEFAULT_SSL_CONTEXT_PROTOCOL = "SSL";
    private int m_port = 7070;
    private String m_password = "123456";
    private String m_pathToKeyStore = "src/main/resources/org/opennms/netmgt/provision/server/mySrvKeystore";
    private String m_keyManagerAlgorithm = "SunX509";
    private String m_keyManagerProvider = "SunJSSE";
    private String m_sslContextProtocol = "SSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws Exception {
        super.init();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm(), this.getKeyManagerProvider());
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = this.getPassword().toCharArray();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(this.getPathToKeyStore());
            ks.load(fis, password);
        }
        kmf.init(ks, password);
        KeyManager[] km = kmf.getKeyManagers();
        SSLContext sslContext = SSLContext.getInstance(this.getSslContextProtocol());
        sslContext.init(km, null, new SecureRandom());
        SSLServerSocketFactory serverFactory = sslContext.getServerSocketFactory();
        this.setServerSocket(serverFactory.createServerSocket(this.getPort()));
        this.onInit();
    }

    @Override
    protected SimpleServerRunnable getRunnable() throws IOException {
        return new SimpleServerRunnable(){

            @Override
            public void run() {
                try {
                    OutputStream out = null;
                    BufferedReader in = null;
                    this.ready();
                    try {
                        SSLServer.this.getServerSocket().setSoTimeout(SSLServer.this.getTimeout());
                        SSLServer.this.setSocket(SSLServer.this.getServerSocket().accept());
                        if (SSLServer.this.getThreadSleepLength() > 0) {
                            Thread.sleep(SSLServer.this.getThreadSleepLength());
                        }
                        SSLServer.this.getSocket().setSoTimeout(SSLServer.this.getTimeout());
                        out = SSLServer.this.getSocket().getOutputStream();
                        if (SSLServer.this.getBanner() != null) {
                            SSLServer.this.sendBanner(out);
                        }
                        in = new BufferedReader(new InputStreamReader(SSLServer.this.getSocket().getInputStream()));
                        SSLServer.this.attemptConversation(in, out);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(out);
                        SSLServer.this.getSocket().close();
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Reader)in);
                    IOUtils.closeQuietly((OutputStream)out);
                    SSLServer.this.getSocket().close();
                }
                catch (Throwable e) {
                    throw new UndeclaredThrowableException(e);
                }
                finally {
                    this.finished();
                    try {
                        SSLServer.this.stopServer();
                    }
                    catch (IOException e) {
                        LOG.debug("unable to stop server", (Throwable)e);
                    }
                }
            }
        };
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPathToKeyStore(String pathToKeyStore) {
        this.m_pathToKeyStore = pathToKeyStore;
    }

    public String getPathToKeyStore() {
        return this.m_pathToKeyStore;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        this.m_keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public String getKeyManagerAlgorithm() {
        return this.m_keyManagerAlgorithm;
    }

    public void setKeyManagerProvider(String keyManagerProvider) {
        this.m_keyManagerProvider = keyManagerProvider;
    }

    public String getKeyManagerProvider() {
        return this.m_keyManagerProvider;
    }

    public void setSslContextProtocol(String sslContextProtocol) {
        this.m_sslContextProtocol = sslContextProtocol;
    }

    public String getSslContextProtocol() {
        return this.m_sslContextProtocol;
    }
}

