/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.textline.TextLineCodecFactory;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.opennms.netmgt.provision.server.SimpleServerHandler;
import org.opennms.netmgt.provision.server.exchange.LineConversation;

public class AsyncSimpleServer {
    private LineConversation m_lineConversation;
    private IoAcceptor m_acceptor;
    private IoHandler m_ioHandler;
    private int m_port = 9123;
    private int m_bufferSize = 2048;
    private int m_idleTime = 10;

    public final void init() throws Exception {
        this.m_lineConversation = new LineConversation();
        this.onInit();
    }

    protected void onInit() {
    }

    public void startServer() throws Exception {
        this.m_acceptor = new NioSocketAcceptor();
        this.m_acceptor.getFilterChain().addLast("logger", (IoFilter)new LoggingFilter());
        this.m_acceptor.getFilterChain().addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new TextLineCodecFactory(StandardCharsets.UTF_8)));
        this.m_acceptor.setHandler(this.getServerHandler());
        this.m_acceptor.getSessionConfig().setReadBufferSize(this.getBufferSize());
        this.m_acceptor.getSessionConfig().setIdleTime(IdleStatus.BOTH_IDLE, this.getIdleTime());
        ((NioSocketAcceptor)this.m_acceptor).setReuseAddress(true);
        this.m_acceptor.bind((SocketAddress)new InetSocketAddress(this.getPort()));
    }

    public void stopServer() throws Exception {
        this.m_acceptor.unbind();
        this.m_acceptor.dispose();
    }

    public void addRequestHandler(String request, String response) {
        this.m_lineConversation.addRequestHandler(request, response);
    }

    public void setBanner(String banner) {
        this.m_lineConversation.setBanner(banner);
    }

    public void setExpectedClose(String closeRequest) {
        this.m_lineConversation.setExpectedClose(closeRequest);
    }

    public void setExpectedClose(String closeRequest, String closeResponse) {
        this.m_lineConversation.setExpectedClose(closeRequest, closeResponse);
    }

    public IoHandler getServerHandler() {
        return this.m_ioHandler != null ? this.m_ioHandler : new SimpleServerHandler(this.m_lineConversation);
    }

    public void setServerHandler(IoHandler handler) {
        this.m_ioHandler = handler;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setBufferSize(int bufferSize) {
        this.m_bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.m_bufferSize;
    }

    public void setIdleTime(int idleTime) {
        this.m_idleTime = idleTime;
    }

    public int getIdleTime() {
        return this.m_idleTime;
    }
}

