/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.server.exchange;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.opennms.netmgt.provision.server.exchange.Exchange;
import org.opennms.netmgt.provision.server.exchange.ResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conversation {
    private static final Logger LOG = LoggerFactory.getLogger(Conversation.class);
    private final List<Exchange> m_conversation = new ArrayList<Exchange>();
    private Exchange m_errorExchange = new ErrorExchange();

    public void addExchange(Exchange exchange) {
        this.m_conversation.add(exchange);
    }

    public void addErrorExchange(Exchange ex) {
        this.m_errorExchange = ex;
    }

    public void attemptServerConversation(BufferedReader in, OutputStream out) throws Exception {
        boolean isFinished = false;
        while (!isFinished) {
            try {
                if (this.m_conversation.size() == 0) {
                    return;
                }
                String line = in.readLine();
                LOG.debug("Server line read: {}", (Object)line);
                if (line == null) {
                    return;
                }
                Exchange ex = this.findMatchingExchange(line);
                if (ex == null) {
                    this.m_errorExchange.sendRequest(out);
                    continue;
                }
                if (ex.sendRequest(out)) continue;
                this.m_errorExchange.sendRequest(out);
            }
            catch (Throwable e) {
                isFinished = true;
                Object[] args = new Object[]{};
                LOG.info("SimpleServer conversation attempt failed", (Object)args, (Object)e);
            }
        }
    }

    public boolean attemptClientConversation(BufferedReader in, OutputStream out) throws IOException {
        for (Exchange ex : this.m_conversation) {
            if (!ex.processResponse(in)) {
                return false;
            }
            LOG.debug("processed response successfully");
            if (!ex.sendRequest(out)) {
                return false;
            }
            LOG.debug("send request if there was a request");
        }
        return true;
    }

    private Exchange findMatchingExchange(String input) throws IOException {
        for (Exchange ex : this.m_conversation) {
            if (!ex.matchResponseByString(input)) continue;
            return ex;
        }
        return null;
    }

    public static ResponseHandler startsWith(final String response) {
        return new ResponseHandler(){

            @Override
            public boolean matches(String input) {
                return input.startsWith(response);
            }
        };
    }

    public static ResponseHandler contains(final String response) {
        return new ResponseHandler(){

            @Override
            public boolean matches(String input) {
                return input.contains(response);
            }
        };
    }

    public static ResponseHandler regexpMatches(final String response) {
        return new ResponseHandler(){

            @Override
            public boolean matches(String input) {
                return input.matches(response);
            }
        };
    }

    public static class ErrorExchange
    implements Exchange {
        private static final String ERROR_STRING = "DEFAULT ERROR STRING: YOU HAVE NOT IMPLEMENTED AN ERROR EXCHANGE";

        @Override
        public boolean matchResponseByString(String response) {
            return false;
        }

        @Override
        public boolean processResponse(BufferedReader in) throws IOException {
            return true;
        }

        @Override
        public boolean sendRequest(OutputStream out) throws IOException {
            out.write(String.format("%s\r\n", ERROR_STRING).getBytes());
            return true;
        }
    }
}

